/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesDiskRequest;
import com.google.cloud.compute.v1.AggregatedListDisksRequest;
import com.google.cloud.compute.v1.CreateSnapshotDiskRequest;
import com.google.cloud.compute.v1.DeleteDiskRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskAggregatedList;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.DisksClient;
import com.google.cloud.compute.v1.DisksScopedList;
import com.google.cloud.compute.v1.GetDiskRequest;
import com.google.cloud.compute.v1.GetIamPolicyDiskRequest;
import com.google.cloud.compute.v1.InsertDiskRequest;
import com.google.cloud.compute.v1.ListDisksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveResourcePoliciesDiskRequest;
import com.google.cloud.compute.v1.ResizeDiskRequest;
import com.google.cloud.compute.v1.SetIamPolicyDiskRequest;
import com.google.cloud.compute.v1.SetLabelsDiskRequest;
import com.google.cloud.compute.v1.TestIamPermissionsDiskRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.DisksStub;
import com.google.cloud.compute.v1.stub.HttpJsonDisksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DisksStubSettings
extends StubSettings<DisksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").build();
    private final UnaryCallSettings<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings;
    private final PagedCallSettings<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<CreateSnapshotDiskRequest, Operation> createSnapshotSettings;
    private final UnaryCallSettings<DeleteDiskRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetDiskRequest, Disk> getSettings;
    private final UnaryCallSettings<GetIamPolicyDiskRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertDiskRequest, Operation> insertSettings;
    private final PagedCallSettings<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings;
    private final UnaryCallSettings<ResizeDiskRequest, Operation> resizeSettings;
    private final UnaryCallSettings<SetIamPolicyDiskRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetLabelsDiskRequest, Operation> setLabelsSettings;
    private final UnaryCallSettings<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListDisksRequest injectToken(AggregatedListDisksRequest payload, String token) {
            return AggregatedListDisksRequest.newBuilder((AggregatedListDisksRequest)payload).setPageToken(token).build();
        }

        public AggregatedListDisksRequest injectPageSize(AggregatedListDisksRequest payload, int pageSize) {
            return AggregatedListDisksRequest.newBuilder((AggregatedListDisksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListDisksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, DisksScopedList>> extractResources(DiskAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().entrySet() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListDisksRequest, DiskList, Disk> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListDisksRequest, DiskList, Disk>(){

        public String emptyToken() {
            return "";
        }

        public ListDisksRequest injectToken(ListDisksRequest payload, String token) {
            return ListDisksRequest.newBuilder((ListDisksRequest)payload).setPageToken(token).build();
        }

        public ListDisksRequest injectPageSize(ListDisksRequest payload, int pageSize) {
            return ListDisksRequest.newBuilder((ListDisksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListDisksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Disk> extractResources(DiskList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse>(){

        public ApiFuture<DisksClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListDisksRequest, DiskAggregatedList> callable, AggregatedListDisksRequest request, ApiCallContext context, ApiFuture<DiskAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DisksClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListDisksRequest, DiskList, DisksClient.ListPagedResponse>(){

        public ApiFuture<DisksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListDisksRequest, DiskList> callable, ListDisksRequest request, ApiCallContext context, ApiFuture<DiskList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DisksClient.ListPagedResponse.createAsync((PageContext<ListDisksRequest, DiskList, Disk>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings() {
        return this.addResourcePoliciesSettings;
    }

    public PagedCallSettings<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<CreateSnapshotDiskRequest, Operation> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public UnaryCallSettings<DeleteDiskRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetDiskRequest, Disk> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyDiskRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertDiskRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings() {
        return this.removeResourcePoliciesSettings;
    }

    public UnaryCallSettings<ResizeDiskRequest, Operation> resizeSettings() {
        return this.resizeSettings;
    }

    public UnaryCallSettings<SetIamPolicyDiskRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetLabelsDiskRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public UnaryCallSettings<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DisksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDisksStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DisksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DisksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DisksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addResourcePoliciesSettings = settingsBuilder.addResourcePoliciesSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.removeResourcePoliciesSettings = settingsBuilder.removeResourcePoliciesSettings().build();
        this.resizeSettings = settingsBuilder.resizeSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DisksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings;
        private final PagedCallSettings.Builder<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotDiskRequest, Operation> createSnapshotSettings;
        private final UnaryCallSettings.Builder<DeleteDiskRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetDiskRequest, Disk> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyDiskRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertDiskRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings;
        private final UnaryCallSettings.Builder<ResizeDiskRequest, Operation> resizeSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyDiskRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetLabelsDiskRequest, Operation> setLabelsSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.createSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.removeResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addResourcePoliciesSettings, this.aggregatedListSettings, this.createSnapshotSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.removeResourcePoliciesSettings, this.resizeSettings, this.setIamPolicySettings, this.setLabelsSettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DisksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DisksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DisksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DisksStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removeResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(DisksStubSettings settings) {
            super((StubSettings)settings);
            this.addResourcePoliciesSettings = settings.addResourcePoliciesSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.removeResourcePoliciesSettings = settings.removeResourcePoliciesSettings.toBuilder();
            this.resizeSettings = settings.resizeSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addResourcePoliciesSettings, this.aggregatedListSettings, this.createSnapshotSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.removeResourcePoliciesSettings, this.resizeSettings, this.setIamPolicySettings, this.setLabelsSettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesSettings() {
            return this.addResourcePoliciesSettings;
        }

        public PagedCallSettings.Builder<AggregatedListDisksRequest, DiskAggregatedList, DisksClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotDiskRequest, Operation> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        public UnaryCallSettings.Builder<DeleteDiskRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetDiskRequest, Disk> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyDiskRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertDiskRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListDisksRequest, DiskList, DisksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesSettings() {
            return this.removeResourcePoliciesSettings;
        }

        public UnaryCallSettings.Builder<ResizeDiskRequest, Operation> resizeSettings() {
            return this.resizeSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyDiskRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetLabelsDiskRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DisksStubSettings build() throws IOException {
            return new DisksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

