/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteGlobalPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.GetGlobalPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.GlobalPublicDelegatedPrefixesSettings;
import com.google.cloud.compute.v1.InsertGlobalPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.ListGlobalPublicDelegatedPrefixesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchGlobalPublicDelegatedPrefixeRequest;
import com.google.cloud.compute.v1.PublicDelegatedPrefix;
import com.google.cloud.compute.v1.PublicDelegatedPrefixList;
import com.google.cloud.compute.v1.stub.GlobalPublicDelegatedPrefixesStub;
import com.google.cloud.compute.v1.stub.GlobalPublicDelegatedPrefixesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GlobalPublicDelegatedPrefixesClient
implements BackgroundResource {
    private final GlobalPublicDelegatedPrefixesSettings settings;
    private final GlobalPublicDelegatedPrefixesStub stub;

    public static final GlobalPublicDelegatedPrefixesClient create() throws IOException {
        return GlobalPublicDelegatedPrefixesClient.create(GlobalPublicDelegatedPrefixesSettings.newBuilder().build());
    }

    public static final GlobalPublicDelegatedPrefixesClient create(GlobalPublicDelegatedPrefixesSettings settings) throws IOException {
        return new GlobalPublicDelegatedPrefixesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalPublicDelegatedPrefixesClient create(GlobalPublicDelegatedPrefixesStub stub) {
        return new GlobalPublicDelegatedPrefixesClient(stub);
    }

    protected GlobalPublicDelegatedPrefixesClient(GlobalPublicDelegatedPrefixesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalPublicDelegatedPrefixesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalPublicDelegatedPrefixesClient(GlobalPublicDelegatedPrefixesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalPublicDelegatedPrefixesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalPublicDelegatedPrefixesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String publicDelegatedPrefix) {
        DeleteGlobalPublicDelegatedPrefixeRequest request = DeleteGlobalPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setPublicDelegatedPrefix(publicDelegatedPrefix).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteGlobalPublicDelegatedPrefixeRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlobalPublicDelegatedPrefixeRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final PublicDelegatedPrefix get(String project, String publicDelegatedPrefix) {
        GetGlobalPublicDelegatedPrefixeRequest request = GetGlobalPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setPublicDelegatedPrefix(publicDelegatedPrefix).build();
        return this.get(request);
    }

    public final PublicDelegatedPrefix get(GetGlobalPublicDelegatedPrefixeRequest request) {
        return (PublicDelegatedPrefix)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalPublicDelegatedPrefixeRequest, PublicDelegatedPrefix> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, PublicDelegatedPrefix publicDelegatedPrefixResource) {
        InsertGlobalPublicDelegatedPrefixeRequest request = InsertGlobalPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setPublicDelegatedPrefixResource(publicDelegatedPrefixResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertGlobalPublicDelegatedPrefixeRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertGlobalPublicDelegatedPrefixeRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListGlobalPublicDelegatedPrefixesRequest request = ListGlobalPublicDelegatedPrefixesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalPublicDelegatedPrefixesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalPublicDelegatedPrefixesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String publicDelegatedPrefix, PublicDelegatedPrefix publicDelegatedPrefixResource) {
        PatchGlobalPublicDelegatedPrefixeRequest request = PatchGlobalPublicDelegatedPrefixeRequest.newBuilder().setProject(project).setPublicDelegatedPrefix(publicDelegatedPrefix).setPublicDelegatedPrefixResource(publicDelegatedPrefixResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchGlobalPublicDelegatedPrefixeRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchGlobalPublicDelegatedPrefixeRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix, ListPage> {
        private ListPage(PageContext<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, PublicDelegatedPrefixList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, PublicDelegatedPrefixList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, ApiFuture<PublicDelegatedPrefixList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalPublicDelegatedPrefixesRequest, PublicDelegatedPrefixList, PublicDelegatedPrefix> context, ApiFuture<PublicDelegatedPrefixList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

