/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonLongRunningClient;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionOperationRequest;
import com.google.cloud.compute.v1.DeleteRegionOperationResponse;
import com.google.cloud.compute.v1.GetRegionOperationRequest;
import com.google.cloud.compute.v1.ListRegionOperationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.RegionOperationsClient;
import com.google.cloud.compute.v1.WaitRegionOperationRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionOperationsCallableFactory;
import com.google.cloud.compute.v1.stub.RegionOperationsStub;
import com.google.cloud.compute.v1.stub.RegionOperationsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonRegionOperationsStub
extends RegionOperationsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<DeleteRegionOperationRequest, DeleteRegionOperationResponse> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionOperations/Delete").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/operations/{operation}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "operation", (Object)request.getOperation());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DeleteRegionOperationResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRegionOperationRequest, Operation> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionOperations/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/operations/{operation}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "operation", (Object)request.getOperation());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).setPollingRequestFactory(compoundOperationId -> {
        List<String> idComponents = Arrays.asList(compoundOperationId.split(":"));
        return GetRegionOperationRequest.newBuilder().setOperation(idComponents.get(0)).setProject(idComponents.get(1)).setRegion(idComponents.get(2)).build();
    }).build();
    private static final ApiMethodDescriptor<ListRegionOperationsRequest, OperationList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionOperations/List").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/operations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)OperationList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<WaitRegionOperationRequest, Operation> waitMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.RegionOperations/Wait").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/operations/{operation}/wait", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "operation", (Object)request.getOperation());
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<DeleteRegionOperationRequest, DeleteRegionOperationResponse> deleteCallable;
    private final UnaryCallable<GetRegionOperationRequest, Operation> getCallable;
    private final UnaryCallable<ListRegionOperationsRequest, OperationList> listCallable;
    private final UnaryCallable<ListRegionOperationsRequest, RegionOperationsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<WaitRegionOperationRequest, Operation> waitCallable;
    private final BackgroundResource backgroundResources;
    private final LongRunningClient longRunningClient;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRegionOperationsStub create(RegionOperationsStubSettings settings) throws IOException {
        return new HttpJsonRegionOperationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRegionOperationsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRegionOperationsStub(RegionOperationsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonRegionOperationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRegionOperationsStub(RegionOperationsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRegionOperationsStub(RegionOperationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRegionOperationsCallableFactory());
    }

    protected HttpJsonRegionOperationsStub(RegionOperationsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings waitTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(waitMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.waitCallable = callableFactory.createUnaryCallable(waitTransportSettings, settings.waitSettings(), clientContext);
        this.longRunningClient = new HttpJsonLongRunningClient(this.getCallable, getMethodDescriptor.getOperationSnapshotFactory(), getMethodDescriptor.getPollingRequestFactory());
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(waitMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DeleteRegionOperationRequest, DeleteRegionOperationResponse> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetRegionOperationRequest, Operation> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<ListRegionOperationsRequest, OperationList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListRegionOperationsRequest, RegionOperationsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<WaitRegionOperationRequest, Operation> waitCallable() {
        return this.waitCallable;
    }

    @Override
    public LongRunningClient longRunningClient() {
        return this.longRunningClient;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

