/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.DeleteGlobalAddressRequest;
import com.google.cloud.compute.v1.GetGlobalAddressRequest;
import com.google.cloud.compute.v1.GlobalAddressesClient;
import com.google.cloud.compute.v1.InsertGlobalAddressRequest;
import com.google.cloud.compute.v1.ListGlobalAddressesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.GlobalAddressesStub;
import com.google.cloud.compute.v1.stub.GlobalAddressesStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalAddressesCallableFactory;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonGlobalAddressesStub
extends GlobalAddressesStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteGlobalAddressRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.GlobalAddresses.Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/addresses/{address}", (FieldsExtractor)new FieldsExtractor<DeleteGlobalAddressRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteGlobalAddressRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "address", (Object)request.getAddress());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteGlobalAddressRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteGlobalAddressRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteGlobalAddressRequest, String>(){

        public String extract(DeleteGlobalAddressRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetGlobalAddressRequest, Address> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.GlobalAddresses.Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/addresses/{address}", (FieldsExtractor)new FieldsExtractor<GetGlobalAddressRequest, Map<String, String>>(){

        public Map<String, String> extract(GetGlobalAddressRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "address", (Object)request.getAddress());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetGlobalAddressRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetGlobalAddressRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetGlobalAddressRequest, String>(){

        public String extract(GetGlobalAddressRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Address.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertGlobalAddressRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.GlobalAddresses.Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/addresses", (FieldsExtractor)new FieldsExtractor<InsertGlobalAddressRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertGlobalAddressRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertGlobalAddressRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertGlobalAddressRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertGlobalAddressRequest, String>(){

        public String extract(InsertGlobalAddressRequest request) {
            return ProtoRestSerializer.create().toBody("addressResource", (Message)request.getAddressResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListGlobalAddressesRequest, AddressList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.GlobalAddresses.List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/addresses", (FieldsExtractor)new FieldsExtractor<ListGlobalAddressesRequest, Map<String, String>>(){

        public Map<String, String> extract(ListGlobalAddressesRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListGlobalAddressesRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListGlobalAddressesRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListGlobalAddressesRequest, String>(){

        public String extract(ListGlobalAddressesRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AddressList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteGlobalAddressRequest, Operation> deleteCallable;
    private final UnaryCallable<GetGlobalAddressRequest, Address> getCallable;
    private final UnaryCallable<InsertGlobalAddressRequest, Operation> insertCallable;
    private final UnaryCallable<ListGlobalAddressesRequest, AddressList> listCallable;
    private final UnaryCallable<ListGlobalAddressesRequest, GlobalAddressesClient.ListPagedResponse> listPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonGlobalAddressesStub create(GlobalAddressesStubSettings settings) throws IOException {
        return new HttpJsonGlobalAddressesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonGlobalAddressesStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonGlobalAddressesStub(GlobalAddressesStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonGlobalAddressesStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonGlobalAddressesStub(GlobalAddressesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonGlobalAddressesStub(GlobalAddressesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonGlobalAddressesCallableFactory());
    }

    protected HttpJsonGlobalAddressesStub(GlobalAddressesStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<DeleteGlobalAddressRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetGlobalAddressRequest, Address> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertGlobalAddressRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListGlobalAddressesRequest, GlobalAddressesClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListGlobalAddressesRequest, AddressList> listCallable() {
        return this.listCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

