/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetZoneRequest;
import com.google.cloud.compute.v1.ListZonesRequest;
import com.google.cloud.compute.v1.Zone;
import com.google.cloud.compute.v1.ZoneList;
import com.google.cloud.compute.v1.ZonesSettings;
import com.google.cloud.compute.v1.stub.ZonesStub;
import com.google.cloud.compute.v1.stub.ZonesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ZonesClient
implements BackgroundResource {
    private final ZonesSettings settings;
    private final ZonesStub stub;

    public static final ZonesClient create() throws IOException {
        return ZonesClient.create(ZonesSettings.newBuilder().build());
    }

    public static final ZonesClient create(ZonesSettings settings) throws IOException {
        return new ZonesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ZonesClient create(ZonesStub stub) {
        return new ZonesClient(stub);
    }

    protected ZonesClient(ZonesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ZonesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ZonesClient(ZonesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ZonesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ZonesStub getStub() {
        return this.stub;
    }

    public final Zone get(String project, String zone) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.get(request);
    }

    public final Zone get(GetZoneRequest request) {
        return (Zone)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetZoneRequest, Zone> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListZonesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListZonesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListZonesRequest, ZoneList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZonesRequest, ZoneList, Zone, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListZonesRequest, ZoneList, Zone, ListPage> {
        private ListPage(PageContext<ListZonesRequest, ZoneList, Zone> context, ZoneList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListZonesRequest, ZoneList, Zone> context, ZoneList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListZonesRequest, ZoneList, Zone> context, ApiFuture<ZoneList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListZonesRequest, ZoneList, Zone, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListZonesRequest, ZoneList, Zone> context, ApiFuture<ZoneList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

