/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AccessConfig;
import com.google.cloud.compute.v1.AddAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.AddResourcePoliciesInstanceRequest;
import com.google.cloud.compute.v1.AggregatedListInstancesRequest;
import com.google.cloud.compute.v1.AttachDiskInstanceRequest;
import com.google.cloud.compute.v1.AttachedDisk;
import com.google.cloud.compute.v1.DeleteAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.DeleteInstanceRequest;
import com.google.cloud.compute.v1.DetachDiskInstanceRequest;
import com.google.cloud.compute.v1.DisplayDevice;
import com.google.cloud.compute.v1.GetGuestAttributesInstanceRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstanceRequest;
import com.google.cloud.compute.v1.GetInstanceRequest;
import com.google.cloud.compute.v1.GetScreenshotInstanceRequest;
import com.google.cloud.compute.v1.GetSerialPortOutputInstanceRequest;
import com.google.cloud.compute.v1.GetShieldedInstanceIdentityInstanceRequest;
import com.google.cloud.compute.v1.GuestAttributes;
import com.google.cloud.compute.v1.InsertInstanceRequest;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceAggregatedList;
import com.google.cloud.compute.v1.InstanceList;
import com.google.cloud.compute.v1.InstanceListReferrers;
import com.google.cloud.compute.v1.InstancesAddResourcePoliciesRequest;
import com.google.cloud.compute.v1.InstancesRemoveResourcePoliciesRequest;
import com.google.cloud.compute.v1.InstancesScopedList;
import com.google.cloud.compute.v1.InstancesSetLabelsRequest;
import com.google.cloud.compute.v1.InstancesSetMachineResourcesRequest;
import com.google.cloud.compute.v1.InstancesSetMachineTypeRequest;
import com.google.cloud.compute.v1.InstancesSetMinCpuPlatformRequest;
import com.google.cloud.compute.v1.InstancesSetServiceAccountRequest;
import com.google.cloud.compute.v1.InstancesSettings;
import com.google.cloud.compute.v1.InstancesStartWithEncryptionKeyRequest;
import com.google.cloud.compute.v1.ListInstancesRequest;
import com.google.cloud.compute.v1.ListReferrersInstancesRequest;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.NetworkInterface;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.Reference;
import com.google.cloud.compute.v1.RemoveResourcePoliciesInstanceRequest;
import com.google.cloud.compute.v1.ResetInstanceRequest;
import com.google.cloud.compute.v1.Scheduling;
import com.google.cloud.compute.v1.Screenshot;
import com.google.cloud.compute.v1.SerialPortOutput;
import com.google.cloud.compute.v1.SetDeletionProtectionInstanceRequest;
import com.google.cloud.compute.v1.SetDiskAutoDeleteInstanceRequest;
import com.google.cloud.compute.v1.SetIamPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetLabelsInstanceRequest;
import com.google.cloud.compute.v1.SetMachineResourcesInstanceRequest;
import com.google.cloud.compute.v1.SetMachineTypeInstanceRequest;
import com.google.cloud.compute.v1.SetMetadataInstanceRequest;
import com.google.cloud.compute.v1.SetMinCpuPlatformInstanceRequest;
import com.google.cloud.compute.v1.SetSchedulingInstanceRequest;
import com.google.cloud.compute.v1.SetServiceAccountInstanceRequest;
import com.google.cloud.compute.v1.SetShieldedInstanceIntegrityPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetTagsInstanceRequest;
import com.google.cloud.compute.v1.ShieldedInstanceConfig;
import com.google.cloud.compute.v1.ShieldedInstanceIdentity;
import com.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy;
import com.google.cloud.compute.v1.SimulateMaintenanceEventInstanceRequest;
import com.google.cloud.compute.v1.StartInstanceRequest;
import com.google.cloud.compute.v1.StartWithEncryptionKeyInstanceRequest;
import com.google.cloud.compute.v1.StopInstanceRequest;
import com.google.cloud.compute.v1.Tags;
import com.google.cloud.compute.v1.TestIamPermissionsInstanceRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.UpdateDisplayDeviceInstanceRequest;
import com.google.cloud.compute.v1.UpdateInstanceRequest;
import com.google.cloud.compute.v1.UpdateNetworkInterfaceInstanceRequest;
import com.google.cloud.compute.v1.UpdateShieldedInstanceConfigInstanceRequest;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.InstancesStub;
import com.google.cloud.compute.v1.stub.InstancesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class InstancesClient
implements BackgroundResource {
    private final InstancesSettings settings;
    private final InstancesStub stub;

    public static final InstancesClient create() throws IOException {
        return InstancesClient.create(InstancesSettings.newBuilder().build());
    }

    public static final InstancesClient create(InstancesSettings settings) throws IOException {
        return new InstancesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstancesClient create(InstancesStub stub) {
        return new InstancesClient(stub);
    }

    protected InstancesClient(InstancesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstancesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstancesClient(InstancesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstancesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstancesStub getStub() {
        return this.stub;
    }

    public final Operation addAccessConfig(String project, String zone, String instance, String networkInterface, AccessConfig accessConfigResource) {
        AddAccessConfigInstanceRequest request = AddAccessConfigInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setNetworkInterface(networkInterface).setAccessConfigResource(accessConfigResource).build();
        return this.addAccessConfig(request);
    }

    public final Operation addAccessConfig(AddAccessConfigInstanceRequest request) {
        return (Operation)this.addAccessConfigCallable().call((Object)request);
    }

    public final UnaryCallable<AddAccessConfigInstanceRequest, Operation> addAccessConfigCallable() {
        return this.stub.addAccessConfigCallable();
    }

    public final Operation addResourcePolicies(String project, String zone, String instance, InstancesAddResourcePoliciesRequest instancesAddResourcePoliciesRequestResource) {
        AddResourcePoliciesInstanceRequest request = AddResourcePoliciesInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesAddResourcePoliciesRequestResource(instancesAddResourcePoliciesRequestResource).build();
        return this.addResourcePolicies(request);
    }

    public final Operation addResourcePolicies(AddResourcePoliciesInstanceRequest request) {
        return (Operation)this.addResourcePoliciesCallable().call((Object)request);
    }

    public final UnaryCallable<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesCallable() {
        return this.stub.addResourcePoliciesCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInstancesRequest request = AggregatedListInstancesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInstancesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInstancesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInstancesRequest, InstanceAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation attachDisk(String project, String zone, String instance, AttachedDisk attachedDiskResource) {
        AttachDiskInstanceRequest request = AttachDiskInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setAttachedDiskResource(attachedDiskResource).build();
        return this.attachDisk(request);
    }

    public final Operation attachDisk(AttachDiskInstanceRequest request) {
        return (Operation)this.attachDiskCallable().call((Object)request);
    }

    public final UnaryCallable<AttachDiskInstanceRequest, Operation> attachDiskCallable() {
        return this.stub.attachDiskCallable();
    }

    public final Operation delete(String project, String zone, String instance) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteInstanceRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation deleteAccessConfig(String project, String zone, String instance, String accessConfig, String networkInterface) {
        DeleteAccessConfigInstanceRequest request = DeleteAccessConfigInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setAccessConfig(accessConfig).setNetworkInterface(networkInterface).build();
        return this.deleteAccessConfig(request);
    }

    public final Operation deleteAccessConfig(DeleteAccessConfigInstanceRequest request) {
        return (Operation)this.deleteAccessConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigCallable() {
        return this.stub.deleteAccessConfigCallable();
    }

    public final Operation detachDisk(String project, String zone, String instance, String deviceName) {
        DetachDiskInstanceRequest request = DetachDiskInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setDeviceName(deviceName).build();
        return this.detachDisk(request);
    }

    public final Operation detachDisk(DetachDiskInstanceRequest request) {
        return (Operation)this.detachDiskCallable().call((Object)request);
    }

    public final UnaryCallable<DetachDiskInstanceRequest, Operation> detachDiskCallable() {
        return this.stub.detachDiskCallable();
    }

    public final Instance get(String project, String zone, String instance) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.get(request);
    }

    public final Instance get(GetInstanceRequest request) {
        return (Instance)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getCallable() {
        return this.stub.getCallable();
    }

    public final GuestAttributes getGuestAttributes(String project, String zone, String instance) {
        GetGuestAttributesInstanceRequest request = GetGuestAttributesInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.getGuestAttributes(request);
    }

    public final GuestAttributes getGuestAttributes(GetGuestAttributesInstanceRequest request) {
        return (GuestAttributes)this.getGuestAttributesCallable().call((Object)request);
    }

    public final UnaryCallable<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesCallable() {
        return this.stub.getGuestAttributesCallable();
    }

    public final Policy getIamPolicy(String project, String zone, String resource) {
        GetIamPolicyInstanceRequest request = GetIamPolicyInstanceRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyInstanceRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyInstanceRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Screenshot getScreenshot(String project, String zone, String instance) {
        GetScreenshotInstanceRequest request = GetScreenshotInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.getScreenshot(request);
    }

    public final Screenshot getScreenshot(GetScreenshotInstanceRequest request) {
        return (Screenshot)this.getScreenshotCallable().call((Object)request);
    }

    public final UnaryCallable<GetScreenshotInstanceRequest, Screenshot> getScreenshotCallable() {
        return this.stub.getScreenshotCallable();
    }

    public final SerialPortOutput getSerialPortOutput(String project, String zone, String instance) {
        GetSerialPortOutputInstanceRequest request = GetSerialPortOutputInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.getSerialPortOutput(request);
    }

    public final SerialPortOutput getSerialPortOutput(GetSerialPortOutputInstanceRequest request) {
        return (SerialPortOutput)this.getSerialPortOutputCallable().call((Object)request);
    }

    public final UnaryCallable<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputCallable() {
        return this.stub.getSerialPortOutputCallable();
    }

    public final ShieldedInstanceIdentity getShieldedInstanceIdentity(String project, String zone, String instance) {
        GetShieldedInstanceIdentityInstanceRequest request = GetShieldedInstanceIdentityInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.getShieldedInstanceIdentity(request);
    }

    public final ShieldedInstanceIdentity getShieldedInstanceIdentity(GetShieldedInstanceIdentityInstanceRequest request) {
        return (ShieldedInstanceIdentity)this.getShieldedInstanceIdentityCallable().call((Object)request);
    }

    public final UnaryCallable<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentityCallable() {
        return this.stub.getShieldedInstanceIdentityCallable();
    }

    public final Operation insert(String project, String zone, Instance instanceResource) {
        InsertInstanceRequest request = InsertInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstanceResource(instanceResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertInstanceRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertInstanceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstancesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, InstanceList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListReferrersPagedResponse listReferrers(String project, String zone, String instance) {
        ListReferrersInstancesRequest request = ListReferrersInstancesRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.listReferrers(request);
    }

    public final ListReferrersPagedResponse listReferrers(ListReferrersInstancesRequest request) {
        return (ListReferrersPagedResponse)((Object)this.listReferrersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReferrersInstancesRequest, ListReferrersPagedResponse> listReferrersPagedCallable() {
        return this.stub.listReferrersPagedCallable();
    }

    public final UnaryCallable<ListReferrersInstancesRequest, InstanceListReferrers> listReferrersCallable() {
        return this.stub.listReferrersCallable();
    }

    public final Operation removeResourcePolicies(String project, String zone, String instance, InstancesRemoveResourcePoliciesRequest instancesRemoveResourcePoliciesRequestResource) {
        RemoveResourcePoliciesInstanceRequest request = RemoveResourcePoliciesInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesRemoveResourcePoliciesRequestResource(instancesRemoveResourcePoliciesRequestResource).build();
        return this.removeResourcePolicies(request);
    }

    public final Operation removeResourcePolicies(RemoveResourcePoliciesInstanceRequest request) {
        return (Operation)this.removeResourcePoliciesCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesCallable() {
        return this.stub.removeResourcePoliciesCallable();
    }

    public final Operation reset(String project, String zone, String instance) {
        ResetInstanceRequest request = ResetInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.reset(request);
    }

    public final Operation reset(ResetInstanceRequest request) {
        return (Operation)this.resetCallable().call((Object)request);
    }

    public final UnaryCallable<ResetInstanceRequest, Operation> resetCallable() {
        return this.stub.resetCallable();
    }

    public final Operation setDeletionProtection(String project, String zone, String resource) {
        SetDeletionProtectionInstanceRequest request = SetDeletionProtectionInstanceRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).build();
        return this.setDeletionProtection(request);
    }

    public final Operation setDeletionProtection(SetDeletionProtectionInstanceRequest request) {
        return (Operation)this.setDeletionProtectionCallable().call((Object)request);
    }

    public final UnaryCallable<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionCallable() {
        return this.stub.setDeletionProtectionCallable();
    }

    public final Operation setDiskAutoDelete(String project, String zone, String instance, boolean autoDelete, String deviceName) {
        SetDiskAutoDeleteInstanceRequest request = SetDiskAutoDeleteInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setAutoDelete(autoDelete).setDeviceName(deviceName).build();
        return this.setDiskAutoDelete(request);
    }

    public final Operation setDiskAutoDelete(SetDiskAutoDeleteInstanceRequest request) {
        return (Operation)this.setDiskAutoDeleteCallable().call((Object)request);
    }

    public final UnaryCallable<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteCallable() {
        return this.stub.setDiskAutoDeleteCallable();
    }

    public final Policy setIamPolicy(String project, String zone, String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyInstanceRequest request = SetIamPolicyInstanceRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyInstanceRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyInstanceRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Operation setLabels(String project, String zone, String instance, InstancesSetLabelsRequest instancesSetLabelsRequestResource) {
        SetLabelsInstanceRequest request = SetLabelsInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesSetLabelsRequestResource(instancesSetLabelsRequestResource).build();
        return this.setLabels(request);
    }

    public final Operation setLabels(SetLabelsInstanceRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsInstanceRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final Operation setMachineResources(String project, String zone, String instance, InstancesSetMachineResourcesRequest instancesSetMachineResourcesRequestResource) {
        SetMachineResourcesInstanceRequest request = SetMachineResourcesInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesSetMachineResourcesRequestResource(instancesSetMachineResourcesRequestResource).build();
        return this.setMachineResources(request);
    }

    public final Operation setMachineResources(SetMachineResourcesInstanceRequest request) {
        return (Operation)this.setMachineResourcesCallable().call((Object)request);
    }

    public final UnaryCallable<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesCallable() {
        return this.stub.setMachineResourcesCallable();
    }

    public final Operation setMachineType(String project, String zone, String instance, InstancesSetMachineTypeRequest instancesSetMachineTypeRequestResource) {
        SetMachineTypeInstanceRequest request = SetMachineTypeInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesSetMachineTypeRequestResource(instancesSetMachineTypeRequestResource).build();
        return this.setMachineType(request);
    }

    public final Operation setMachineType(SetMachineTypeInstanceRequest request) {
        return (Operation)this.setMachineTypeCallable().call((Object)request);
    }

    public final UnaryCallable<SetMachineTypeInstanceRequest, Operation> setMachineTypeCallable() {
        return this.stub.setMachineTypeCallable();
    }

    public final Operation setMetadata(String project, String zone, String instance, Metadata metadataResource) {
        SetMetadataInstanceRequest request = SetMetadataInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setMetadataResource(metadataResource).build();
        return this.setMetadata(request);
    }

    public final Operation setMetadata(SetMetadataInstanceRequest request) {
        return (Operation)this.setMetadataCallable().call((Object)request);
    }

    public final UnaryCallable<SetMetadataInstanceRequest, Operation> setMetadataCallable() {
        return this.stub.setMetadataCallable();
    }

    public final Operation setMinCpuPlatform(String project, String zone, String instance, InstancesSetMinCpuPlatformRequest instancesSetMinCpuPlatformRequestResource) {
        SetMinCpuPlatformInstanceRequest request = SetMinCpuPlatformInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesSetMinCpuPlatformRequestResource(instancesSetMinCpuPlatformRequestResource).build();
        return this.setMinCpuPlatform(request);
    }

    public final Operation setMinCpuPlatform(SetMinCpuPlatformInstanceRequest request) {
        return (Operation)this.setMinCpuPlatformCallable().call((Object)request);
    }

    public final UnaryCallable<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformCallable() {
        return this.stub.setMinCpuPlatformCallable();
    }

    public final Operation setScheduling(String project, String zone, String instance, Scheduling schedulingResource) {
        SetSchedulingInstanceRequest request = SetSchedulingInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setSchedulingResource(schedulingResource).build();
        return this.setScheduling(request);
    }

    public final Operation setScheduling(SetSchedulingInstanceRequest request) {
        return (Operation)this.setSchedulingCallable().call((Object)request);
    }

    public final UnaryCallable<SetSchedulingInstanceRequest, Operation> setSchedulingCallable() {
        return this.stub.setSchedulingCallable();
    }

    public final Operation setServiceAccount(String project, String zone, String instance, InstancesSetServiceAccountRequest instancesSetServiceAccountRequestResource) {
        SetServiceAccountInstanceRequest request = SetServiceAccountInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesSetServiceAccountRequestResource(instancesSetServiceAccountRequestResource).build();
        return this.setServiceAccount(request);
    }

    public final Operation setServiceAccount(SetServiceAccountInstanceRequest request) {
        return (Operation)this.setServiceAccountCallable().call((Object)request);
    }

    public final UnaryCallable<SetServiceAccountInstanceRequest, Operation> setServiceAccountCallable() {
        return this.stub.setServiceAccountCallable();
    }

    public final Operation setShieldedInstanceIntegrityPolicy(String project, String zone, String instance, ShieldedInstanceIntegrityPolicy shieldedInstanceIntegrityPolicyResource) {
        SetShieldedInstanceIntegrityPolicyInstanceRequest request = SetShieldedInstanceIntegrityPolicyInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setShieldedInstanceIntegrityPolicyResource(shieldedInstanceIntegrityPolicyResource).build();
        return this.setShieldedInstanceIntegrityPolicy(request);
    }

    public final Operation setShieldedInstanceIntegrityPolicy(SetShieldedInstanceIntegrityPolicyInstanceRequest request) {
        return (Operation)this.setShieldedInstanceIntegrityPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicyCallable() {
        return this.stub.setShieldedInstanceIntegrityPolicyCallable();
    }

    public final Operation setTags(String project, String zone, String instance, Tags tagsResource) {
        SetTagsInstanceRequest request = SetTagsInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setTagsResource(tagsResource).build();
        return this.setTags(request);
    }

    public final Operation setTags(SetTagsInstanceRequest request) {
        return (Operation)this.setTagsCallable().call((Object)request);
    }

    public final UnaryCallable<SetTagsInstanceRequest, Operation> setTagsCallable() {
        return this.stub.setTagsCallable();
    }

    public final Operation simulateMaintenanceEvent(String project, String zone, String instance) {
        SimulateMaintenanceEventInstanceRequest request = SimulateMaintenanceEventInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.simulateMaintenanceEvent(request);
    }

    public final Operation simulateMaintenanceEvent(SimulateMaintenanceEventInstanceRequest request) {
        return (Operation)this.simulateMaintenanceEventCallable().call((Object)request);
    }

    public final UnaryCallable<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventCallable() {
        return this.stub.simulateMaintenanceEventCallable();
    }

    public final Operation start(String project, String zone, String instance) {
        StartInstanceRequest request = StartInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.start(request);
    }

    public final Operation start(StartInstanceRequest request) {
        return (Operation)this.startCallable().call((Object)request);
    }

    public final UnaryCallable<StartInstanceRequest, Operation> startCallable() {
        return this.stub.startCallable();
    }

    public final Operation startWithEncryptionKey(String project, String zone, String instance, InstancesStartWithEncryptionKeyRequest instancesStartWithEncryptionKeyRequestResource) {
        StartWithEncryptionKeyInstanceRequest request = StartWithEncryptionKeyInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstancesStartWithEncryptionKeyRequestResource(instancesStartWithEncryptionKeyRequestResource).build();
        return this.startWithEncryptionKey(request);
    }

    public final Operation startWithEncryptionKey(StartWithEncryptionKeyInstanceRequest request) {
        return (Operation)this.startWithEncryptionKeyCallable().call((Object)request);
    }

    public final UnaryCallable<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeyCallable() {
        return this.stub.startWithEncryptionKeyCallable();
    }

    public final Operation stop(String project, String zone, String instance) {
        StopInstanceRequest request = StopInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).build();
        return this.stop(request);
    }

    public final Operation stop(StopInstanceRequest request) {
        return (Operation)this.stopCallable().call((Object)request);
    }

    public final UnaryCallable<StopInstanceRequest, Operation> stopCallable() {
        return this.stub.stopCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInstanceRequest request = TestIamPermissionsInstanceRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsInstanceRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final Operation update(String project, String zone, String instance, Instance instanceResource) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setInstanceResource(instanceResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateInstanceRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final Operation updateAccessConfig(String project, String zone, String instance, String networkInterface, AccessConfig accessConfigResource) {
        UpdateAccessConfigInstanceRequest request = UpdateAccessConfigInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setNetworkInterface(networkInterface).setAccessConfigResource(accessConfigResource).build();
        return this.updateAccessConfig(request);
    }

    public final Operation updateAccessConfig(UpdateAccessConfigInstanceRequest request) {
        return (Operation)this.updateAccessConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigCallable() {
        return this.stub.updateAccessConfigCallable();
    }

    public final Operation updateDisplayDevice(String project, String zone, String instance, DisplayDevice displayDeviceResource) {
        UpdateDisplayDeviceInstanceRequest request = UpdateDisplayDeviceInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setDisplayDeviceResource(displayDeviceResource).build();
        return this.updateDisplayDevice(request);
    }

    public final Operation updateDisplayDevice(UpdateDisplayDeviceInstanceRequest request) {
        return (Operation)this.updateDisplayDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceCallable() {
        return this.stub.updateDisplayDeviceCallable();
    }

    public final Operation updateNetworkInterface(String project, String zone, String instance, String networkInterface, NetworkInterface networkInterfaceResource) {
        UpdateNetworkInterfaceInstanceRequest request = UpdateNetworkInterfaceInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setNetworkInterface(networkInterface).setNetworkInterfaceResource(networkInterfaceResource).build();
        return this.updateNetworkInterface(request);
    }

    public final Operation updateNetworkInterface(UpdateNetworkInterfaceInstanceRequest request) {
        return (Operation)this.updateNetworkInterfaceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceCallable() {
        return this.stub.updateNetworkInterfaceCallable();
    }

    public final Operation updateShieldedInstanceConfig(String project, String zone, String instance, ShieldedInstanceConfig shieldedInstanceConfigResource) {
        UpdateShieldedInstanceConfigInstanceRequest request = UpdateShieldedInstanceConfigInstanceRequest.newBuilder().setProject(project).setZone(zone).setInstance(instance).setShieldedInstanceConfigResource(shieldedInstanceConfigResource).build();
        return this.updateShieldedInstanceConfig(request);
    }

    public final Operation updateShieldedInstanceConfig(UpdateShieldedInstanceConfigInstanceRequest request) {
        return (Operation)this.updateShieldedInstanceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigCallable() {
        return this.stub.updateShieldedInstanceConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListReferrersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReferrersInstancesRequest, InstanceListReferrers, Reference, ListReferrersPage, ListReferrersFixedSizeCollection> {
        private ListReferrersFixedSizeCollection(List<ListReferrersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReferrersFixedSizeCollection createEmptyCollection() {
            return new ListReferrersFixedSizeCollection(null, 0);
        }

        protected ListReferrersFixedSizeCollection createCollection(List<ListReferrersPage> pages, int collectionSize) {
            return new ListReferrersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReferrersPage
    extends AbstractPage<ListReferrersInstancesRequest, InstanceListReferrers, Reference, ListReferrersPage> {
        private ListReferrersPage(PageContext<ListReferrersInstancesRequest, InstanceListReferrers, Reference> context, InstanceListReferrers response) {
            super(context, (Object)response);
        }

        private static ListReferrersPage createEmptyPage() {
            return new ListReferrersPage(null, null);
        }

        protected ListReferrersPage createPage(PageContext<ListReferrersInstancesRequest, InstanceListReferrers, Reference> context, InstanceListReferrers response) {
            return new ListReferrersPage(context, response);
        }

        public ApiFuture<ListReferrersPage> createPageAsync(PageContext<ListReferrersInstancesRequest, InstanceListReferrers, Reference> context, ApiFuture<InstanceListReferrers> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReferrersPagedResponse
    extends AbstractPagedListResponse<ListReferrersInstancesRequest, InstanceListReferrers, Reference, ListReferrersPage, ListReferrersFixedSizeCollection> {
        public static ApiFuture<ListReferrersPagedResponse> createAsync(PageContext<ListReferrersInstancesRequest, InstanceListReferrers, Reference> context, ApiFuture<InstanceListReferrers> futureResponse) {
            ApiFuture<ListReferrersPage> futurePage = ListReferrersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListReferrersPage, ListReferrersPagedResponse>(){

                public ListReferrersPagedResponse apply(ListReferrersPage input) {
                    return new ListReferrersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListReferrersPagedResponse(ListReferrersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReferrersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, InstanceList, Instance, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstancesRequest, InstanceList, Instance, ListPage> {
        private ListPage(PageContext<ListInstancesRequest, InstanceList, Instance> context, InstanceList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstancesRequest, InstanceList, Instance> context, InstanceList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstancesRequest, InstanceList, Instance> context, ApiFuture<InstanceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, InstanceList, Instance, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstancesRequest, InstanceList, Instance> context, ApiFuture<InstanceList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>> context, InstanceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>> context, InstanceAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>> context, ApiFuture<InstanceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>> context, ApiFuture<InstanceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

