/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteFirewallRequest;
import com.google.cloud.compute.v1.Firewall;
import com.google.cloud.compute.v1.FirewallList;
import com.google.cloud.compute.v1.FirewallsClient;
import com.google.cloud.compute.v1.GetFirewallRequest;
import com.google.cloud.compute.v1.InsertFirewallRequest;
import com.google.cloud.compute.v1.ListFirewallsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallRequest;
import com.google.cloud.compute.v1.UpdateFirewallRequest;
import com.google.cloud.compute.v1.stub.FirewallsStub;
import com.google.cloud.compute.v1.stub.FirewallsStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonFirewallsCallableFactory;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonFirewallsStub
extends FirewallsStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteFirewallRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Firewalls.Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/firewalls/{firewall}", (FieldsExtractor)new FieldsExtractor<DeleteFirewallRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteFirewallRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "firewall", (Object)request.getFirewall());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteFirewallRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteFirewallRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteFirewallRequest, String>(){

        public String extract(DeleteFirewallRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetFirewallRequest, Firewall> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Firewalls.Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/firewalls/{firewall}", (FieldsExtractor)new FieldsExtractor<GetFirewallRequest, Map<String, String>>(){

        public Map<String, String> extract(GetFirewallRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "firewall", (Object)request.getFirewall());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetFirewallRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetFirewallRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetFirewallRequest, String>(){

        public String extract(GetFirewallRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Firewall.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertFirewallRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Firewalls.Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/firewalls", (FieldsExtractor)new FieldsExtractor<InsertFirewallRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertFirewallRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertFirewallRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertFirewallRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertFirewallRequest, String>(){

        public String extract(InsertFirewallRequest request) {
            return ProtoRestSerializer.create().toBody("firewallResource", (Message)request.getFirewallResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListFirewallsRequest, FirewallList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Firewalls.List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/firewalls", (FieldsExtractor)new FieldsExtractor<ListFirewallsRequest, Map<String, String>>(){

        public Map<String, String> extract(ListFirewallsRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListFirewallsRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListFirewallsRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListFirewallsRequest, String>(){

        public String extract(ListFirewallsRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FirewallList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchFirewallRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Firewalls.Patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/firewalls/{firewall}", (FieldsExtractor)new FieldsExtractor<PatchFirewallRequest, Map<String, String>>(){

        public Map<String, String> extract(PatchFirewallRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "firewall", (Object)request.getFirewall());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<PatchFirewallRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(PatchFirewallRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<PatchFirewallRequest, String>(){

        public String extract(PatchFirewallRequest request) {
            return ProtoRestSerializer.create().toBody("firewallResource", (Message)request.getFirewallResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateFirewallRequest, Operation> updateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Firewalls.Update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/global/firewalls/{firewall}", (FieldsExtractor)new FieldsExtractor<UpdateFirewallRequest, Map<String, String>>(){

        public Map<String, String> extract(UpdateFirewallRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "firewall", (Object)request.getFirewall());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<UpdateFirewallRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(UpdateFirewallRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<UpdateFirewallRequest, String>(){

        public String extract(UpdateFirewallRequest request) {
            return ProtoRestSerializer.create().toBody("firewallResource", (Message)request.getFirewallResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteFirewallRequest, Operation> deleteCallable;
    private final UnaryCallable<GetFirewallRequest, Firewall> getCallable;
    private final UnaryCallable<InsertFirewallRequest, Operation> insertCallable;
    private final UnaryCallable<ListFirewallsRequest, FirewallList> listCallable;
    private final UnaryCallable<ListFirewallsRequest, FirewallsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<PatchFirewallRequest, Operation> patchCallable;
    private final UnaryCallable<UpdateFirewallRequest, Operation> updateCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFirewallsStub create(FirewallsStubSettings settings) throws IOException {
        return new HttpJsonFirewallsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonFirewallsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFirewallsStub(FirewallsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonFirewallsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFirewallsStub(FirewallsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFirewallsStub(FirewallsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFirewallsCallableFactory());
    }

    protected HttpJsonFirewallsStub(FirewallsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).build();
        HttpJsonCallSettings updateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMethodDescriptor).build();
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.updateCallable = callableFactory.createUnaryCallable(updateTransportSettings, settings.updateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<DeleteFirewallRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetFirewallRequest, Firewall> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<InsertFirewallRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListFirewallsRequest, FirewallsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListFirewallsRequest, FirewallList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<PatchFirewallRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public UnaryCallable<UpdateFirewallRequest, Operation> updateCallable() {
        return this.updateCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

