/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagersRecreateInstancesRequest
implements ApiMessage {
    private final List<String> instances;
    private static final InstanceGroupManagersRecreateInstancesRequest DEFAULT_INSTANCE = new InstanceGroupManagersRecreateInstancesRequest();

    private InstanceGroupManagersRecreateInstancesRequest() {
        this.instances = null;
    }

    private InstanceGroupManagersRecreateInstancesRequest(List<String> instances) {
        this.instances = instances;
    }

    public Object getFieldValue(String fieldName) {
        if ("instances".equals(fieldName)) {
            return this.instances;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getInstancesList() {
        return this.instances;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagersRecreateInstancesRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagersRecreateInstancesRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagersRecreateInstancesRequest{instances=" + this.instances + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagersRecreateInstancesRequest) {
            InstanceGroupManagersRecreateInstancesRequest that = (InstanceGroupManagersRecreateInstancesRequest)o;
            return Objects.equals(this.instances, that.getInstancesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances);
    }

    public static class Builder {
        private List<String> instances;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagersRecreateInstancesRequest other) {
            if (other == InstanceGroupManagersRecreateInstancesRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            return this;
        }

        Builder(InstanceGroupManagersRecreateInstancesRequest source) {
            this.instances = source.instances;
        }

        public List<String> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<String> instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(String instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.add(instances);
            return this;
        }

        public InstanceGroupManagersRecreateInstancesRequest build() {
            return new InstanceGroupManagersRecreateInstancesRequest(this.instances);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            return newBuilder;
        }
    }
}

