/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AuditLogConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AuditConfig
implements ApiMessage {
    private final List<AuditLogConfig> auditLogConfigs;
    private final List<String> exemptedMembers;
    private final String service;
    private static final AuditConfig DEFAULT_INSTANCE = new AuditConfig();

    private AuditConfig() {
        this.auditLogConfigs = null;
        this.exemptedMembers = null;
        this.service = null;
    }

    private AuditConfig(List<AuditLogConfig> auditLogConfigs, List<String> exemptedMembers, String service) {
        this.auditLogConfigs = auditLogConfigs;
        this.exemptedMembers = exemptedMembers;
        this.service = service;
    }

    public Object getFieldValue(String fieldName) {
        if ("auditLogConfigs".equals(fieldName)) {
            return this.auditLogConfigs;
        }
        if ("exemptedMembers".equals(fieldName)) {
            return this.exemptedMembers;
        }
        if ("service".equals(fieldName)) {
            return this.service;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<AuditLogConfig> getAuditLogConfigsList() {
        return this.auditLogConfigs;
    }

    public List<String> getExemptedMembersList() {
        return this.exemptedMembers;
    }

    public String getService() {
        return this.service;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AuditConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AuditConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AuditConfig{auditLogConfigs=" + this.auditLogConfigs + ", exemptedMembers=" + this.exemptedMembers + ", service=" + this.service + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AuditConfig) {
            AuditConfig that = (AuditConfig)o;
            return Objects.equals(this.auditLogConfigs, that.getAuditLogConfigsList()) && Objects.equals(this.exemptedMembers, that.getExemptedMembersList()) && Objects.equals(this.service, that.getService());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.auditLogConfigs, this.exemptedMembers, this.service);
    }

    public static class Builder {
        private List<AuditLogConfig> auditLogConfigs;
        private List<String> exemptedMembers;
        private String service;

        Builder() {
        }

        public Builder mergeFrom(AuditConfig other) {
            if (other == AuditConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getAuditLogConfigsList() != null) {
                this.auditLogConfigs = other.auditLogConfigs;
            }
            if (other.getExemptedMembersList() != null) {
                this.exemptedMembers = other.exemptedMembers;
            }
            if (other.getService() != null) {
                this.service = other.service;
            }
            return this;
        }

        Builder(AuditConfig source) {
            this.auditLogConfigs = source.auditLogConfigs;
            this.exemptedMembers = source.exemptedMembers;
            this.service = source.service;
        }

        public List<AuditLogConfig> getAuditLogConfigsList() {
            return this.auditLogConfigs;
        }

        public Builder addAllAuditLogConfigs(List<AuditLogConfig> auditLogConfigs) {
            if (this.auditLogConfigs == null) {
                this.auditLogConfigs = new LinkedList<AuditLogConfig>();
            }
            this.auditLogConfigs.addAll(auditLogConfigs);
            return this;
        }

        public Builder addAuditLogConfigs(AuditLogConfig auditLogConfigs) {
            if (this.auditLogConfigs == null) {
                this.auditLogConfigs = new LinkedList<AuditLogConfig>();
            }
            this.auditLogConfigs.add(auditLogConfigs);
            return this;
        }

        public List<String> getExemptedMembersList() {
            return this.exemptedMembers;
        }

        public Builder addAllExemptedMembers(List<String> exemptedMembers) {
            if (this.exemptedMembers == null) {
                this.exemptedMembers = new LinkedList<String>();
            }
            this.exemptedMembers.addAll(exemptedMembers);
            return this;
        }

        public Builder addExemptedMembers(String exemptedMembers) {
            if (this.exemptedMembers == null) {
                this.exemptedMembers = new LinkedList<String>();
            }
            this.exemptedMembers.add(exemptedMembers);
            return this;
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public AuditConfig build() {
            return new AuditConfig(this.auditLogConfigs, this.exemptedMembers, this.service);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllAuditLogConfigs(this.auditLogConfigs);
            newBuilder.addAllExemptedMembers(this.exemptedMembers);
            newBuilder.setService(this.service);
            return newBuilder;
        }
    }
}

