/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DiskType;
import com.google.cloud.compute.v1.GetRegionDiskTypeHttpRequest;
import com.google.cloud.compute.v1.ListRegionDiskTypesHttpRequest;
import com.google.cloud.compute.v1.ProjectRegionDiskTypeName;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.RegionDiskTypeList;
import com.google.cloud.compute.v1.RegionDiskTypeSettings;
import com.google.cloud.compute.v1.stub.RegionDiskTypeStub;
import com.google.cloud.compute.v1.stub.RegionDiskTypeStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionDiskTypeClient
implements BackgroundResource {
    private final RegionDiskTypeSettings settings;
    private final RegionDiskTypeStub stub;

    public static final RegionDiskTypeClient create() throws IOException {
        return RegionDiskTypeClient.create(RegionDiskTypeSettings.newBuilder().build());
    }

    public static final RegionDiskTypeClient create(RegionDiskTypeSettings settings) throws IOException {
        return new RegionDiskTypeClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionDiskTypeClient create(RegionDiskTypeStub stub) {
        return new RegionDiskTypeClient(stub);
    }

    protected RegionDiskTypeClient(RegionDiskTypeSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionDiskTypeStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionDiskTypeClient(RegionDiskTypeStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionDiskTypeSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionDiskTypeStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final DiskType getRegionDiskType(ProjectRegionDiskTypeName diskType) {
        GetRegionDiskTypeHttpRequest request = GetRegionDiskTypeHttpRequest.newBuilder().setDiskType(diskType == null ? null : diskType.toString()).build();
        return this.getRegionDiskType(request);
    }

    @BetaApi
    public final DiskType getRegionDiskType(String diskType) {
        GetRegionDiskTypeHttpRequest request = GetRegionDiskTypeHttpRequest.newBuilder().setDiskType(diskType).build();
        return this.getRegionDiskType(request);
    }

    @BetaApi
    public final DiskType getRegionDiskType(GetRegionDiskTypeHttpRequest request) {
        return (DiskType)this.getRegionDiskTypeCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionDiskTypeHttpRequest, DiskType> getRegionDiskTypeCallable() {
        return this.stub.getRegionDiskTypeCallable();
    }

    @BetaApi
    public final ListRegionDiskTypesPagedResponse listRegionDiskTypes(ProjectRegionName region) {
        ListRegionDiskTypesHttpRequest request = ListRegionDiskTypesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionDiskTypes(request);
    }

    @BetaApi
    public final ListRegionDiskTypesPagedResponse listRegionDiskTypes(String region) {
        ListRegionDiskTypesHttpRequest request = ListRegionDiskTypesHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionDiskTypes(request);
    }

    @BetaApi
    public final ListRegionDiskTypesPagedResponse listRegionDiskTypes(ListRegionDiskTypesHttpRequest request) {
        return (ListRegionDiskTypesPagedResponse)((Object)this.listRegionDiskTypesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionDiskTypesHttpRequest, ListRegionDiskTypesPagedResponse> listRegionDiskTypesPagedCallable() {
        return this.stub.listRegionDiskTypesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionDiskTypesHttpRequest, RegionDiskTypeList> listRegionDiskTypesCallable() {
        return this.stub.listRegionDiskTypesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionDiskTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType, ListRegionDiskTypesPage, ListRegionDiskTypesFixedSizeCollection> {
        private ListRegionDiskTypesFixedSizeCollection(List<ListRegionDiskTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionDiskTypesFixedSizeCollection createEmptyCollection() {
            return new ListRegionDiskTypesFixedSizeCollection(null, 0);
        }

        protected ListRegionDiskTypesFixedSizeCollection createCollection(List<ListRegionDiskTypesPage> pages, int collectionSize) {
            return new ListRegionDiskTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionDiskTypesPage
    extends AbstractPage<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType, ListRegionDiskTypesPage> {
        private ListRegionDiskTypesPage(PageContext<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType> context, RegionDiskTypeList response) {
            super(context, (Object)response);
        }

        private static ListRegionDiskTypesPage createEmptyPage() {
            return new ListRegionDiskTypesPage(null, null);
        }

        protected ListRegionDiskTypesPage createPage(PageContext<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType> context, RegionDiskTypeList response) {
            return new ListRegionDiskTypesPage(context, response);
        }

        public ApiFuture<ListRegionDiskTypesPage> createPageAsync(PageContext<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType> context, ApiFuture<RegionDiskTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionDiskTypesPagedResponse
    extends AbstractPagedListResponse<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType, ListRegionDiskTypesPage, ListRegionDiskTypesFixedSizeCollection> {
        public static ApiFuture<ListRegionDiskTypesPagedResponse> createAsync(PageContext<ListRegionDiskTypesHttpRequest, RegionDiskTypeList, DiskType> context, ApiFuture<RegionDiskTypeList> futureResponse) {
            ApiFuture<ListRegionDiskTypesPage> futurePage = ListRegionDiskTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionDiskTypesPage, ListRegionDiskTypesPagedResponse>(){

                public ListRegionDiskTypesPagedResponse apply(ListRegionDiskTypesPage input) {
                    return new ListRegionDiskTypesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionDiskTypesPagedResponse(ListRegionDiskTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionDiskTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

