/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.CreateSnapshotRegionDiskHttpRequest;
import com.google.cloud.compute.v1.DeleteRegionDiskHttpRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.GetRegionDiskHttpRequest;
import com.google.cloud.compute.v1.InsertRegionDiskHttpRequest;
import com.google.cloud.compute.v1.ListRegionDisksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionDiskClient;
import com.google.cloud.compute.v1.ResizeRegionDiskHttpRequest;
import com.google.cloud.compute.v1.SetLabelsRegionDiskHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionDiskHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonRegionDiskStub;
import com.google.cloud.compute.v1.stub.RegionDiskStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionDiskStubSettings
extends StubSettings<RegionDiskStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<CreateSnapshotRegionDiskHttpRequest, Operation> createSnapshotRegionDiskSettings;
    private final UnaryCallSettings<DeleteRegionDiskHttpRequest, Operation> deleteRegionDiskSettings;
    private final UnaryCallSettings<GetRegionDiskHttpRequest, Disk> getRegionDiskSettings;
    private final UnaryCallSettings<InsertRegionDiskHttpRequest, Operation> insertRegionDiskSettings;
    private final PagedCallSettings<ListRegionDisksHttpRequest, DiskList, RegionDiskClient.ListRegionDisksPagedResponse> listRegionDisksSettings;
    private final UnaryCallSettings<ResizeRegionDiskHttpRequest, Operation> resizeRegionDiskSettings;
    private final UnaryCallSettings<SetLabelsRegionDiskHttpRequest, Operation> setLabelsRegionDiskSettings;
    private final UnaryCallSettings<TestIamPermissionsRegionDiskHttpRequest, TestPermissionsResponse> testIamPermissionsRegionDiskSettings;
    private static final PagedListDescriptor<ListRegionDisksHttpRequest, DiskList, Disk> LIST_REGION_DISKS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionDisksHttpRequest, DiskList, Disk>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionDisksHttpRequest injectToken(ListRegionDisksHttpRequest payload, String token) {
            return ListRegionDisksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionDisksHttpRequest injectPageSize(ListRegionDisksHttpRequest payload, int pageSize) {
            return ListRegionDisksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionDisksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Disk> extractResources(DiskList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionDisksHttpRequest, DiskList, RegionDiskClient.ListRegionDisksPagedResponse> LIST_REGION_DISKS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionDisksHttpRequest, DiskList, RegionDiskClient.ListRegionDisksPagedResponse>(){

        public ApiFuture<RegionDiskClient.ListRegionDisksPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionDisksHttpRequest, DiskList> callable, ListRegionDisksHttpRequest request, ApiCallContext context, ApiFuture<DiskList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_DISKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionDiskClient.ListRegionDisksPagedResponse.createAsync((PageContext<ListRegionDisksHttpRequest, DiskList, Disk>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSnapshotRegionDiskHttpRequest, Operation> createSnapshotRegionDiskSettings() {
        return this.createSnapshotRegionDiskSettings;
    }

    public UnaryCallSettings<DeleteRegionDiskHttpRequest, Operation> deleteRegionDiskSettings() {
        return this.deleteRegionDiskSettings;
    }

    public UnaryCallSettings<GetRegionDiskHttpRequest, Disk> getRegionDiskSettings() {
        return this.getRegionDiskSettings;
    }

    public UnaryCallSettings<InsertRegionDiskHttpRequest, Operation> insertRegionDiskSettings() {
        return this.insertRegionDiskSettings;
    }

    public PagedCallSettings<ListRegionDisksHttpRequest, DiskList, RegionDiskClient.ListRegionDisksPagedResponse> listRegionDisksSettings() {
        return this.listRegionDisksSettings;
    }

    public UnaryCallSettings<ResizeRegionDiskHttpRequest, Operation> resizeRegionDiskSettings() {
        return this.resizeRegionDiskSettings;
    }

    public UnaryCallSettings<SetLabelsRegionDiskHttpRequest, Operation> setLabelsRegionDiskSettings() {
        return this.setLabelsRegionDiskSettings;
    }

    public UnaryCallSettings<TestIamPermissionsRegionDiskHttpRequest, TestPermissionsResponse> testIamPermissionsRegionDiskSettings() {
        return this.testIamPermissionsRegionDiskSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionDiskStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionDiskStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionDiskStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionDiskStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionDiskStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSnapshotRegionDiskSettings = settingsBuilder.createSnapshotRegionDiskSettings().build();
        this.deleteRegionDiskSettings = settingsBuilder.deleteRegionDiskSettings().build();
        this.getRegionDiskSettings = settingsBuilder.getRegionDiskSettings().build();
        this.insertRegionDiskSettings = settingsBuilder.insertRegionDiskSettings().build();
        this.listRegionDisksSettings = settingsBuilder.listRegionDisksSettings().build();
        this.resizeRegionDiskSettings = settingsBuilder.resizeRegionDiskSettings().build();
        this.setLabelsRegionDiskSettings = settingsBuilder.setLabelsRegionDiskSettings().build();
        this.testIamPermissionsRegionDiskSettings = settingsBuilder.testIamPermissionsRegionDiskSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionDiskStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSnapshotRegionDiskHttpRequest, Operation> createSnapshotRegionDiskSettings;
        private final UnaryCallSettings.Builder<DeleteRegionDiskHttpRequest, Operation> deleteRegionDiskSettings;
        private final UnaryCallSettings.Builder<GetRegionDiskHttpRequest, Disk> getRegionDiskSettings;
        private final UnaryCallSettings.Builder<InsertRegionDiskHttpRequest, Operation> insertRegionDiskSettings;
        private final PagedCallSettings.Builder<ListRegionDisksHttpRequest, DiskList, RegionDiskClient.ListRegionDisksPagedResponse> listRegionDisksSettings;
        private final UnaryCallSettings.Builder<ResizeRegionDiskHttpRequest, Operation> resizeRegionDiskSettings;
        private final UnaryCallSettings.Builder<SetLabelsRegionDiskHttpRequest, Operation> setLabelsRegionDiskSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRegionDiskHttpRequest, TestPermissionsResponse> testIamPermissionsRegionDiskSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSnapshotRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionDisksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_DISKS_PAGE_STR_FACT);
            this.resizeRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsRegionDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSnapshotRegionDiskSettings, this.deleteRegionDiskSettings, this.getRegionDiskSettings, this.insertRegionDiskSettings, this.listRegionDisksSettings, this.resizeRegionDiskSettings, this.setLabelsRegionDiskSettings, this.testIamPermissionsRegionDiskSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionDiskStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionDiskStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionDiskStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionDiskStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSnapshotRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionDisksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resizeRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setLabelsRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsRegionDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionDiskStubSettings settings) {
            super((StubSettings)settings);
            this.createSnapshotRegionDiskSettings = settings.createSnapshotRegionDiskSettings.toBuilder();
            this.deleteRegionDiskSettings = settings.deleteRegionDiskSettings.toBuilder();
            this.getRegionDiskSettings = settings.getRegionDiskSettings.toBuilder();
            this.insertRegionDiskSettings = settings.insertRegionDiskSettings.toBuilder();
            this.listRegionDisksSettings = settings.listRegionDisksSettings.toBuilder();
            this.resizeRegionDiskSettings = settings.resizeRegionDiskSettings.toBuilder();
            this.setLabelsRegionDiskSettings = settings.setLabelsRegionDiskSettings.toBuilder();
            this.testIamPermissionsRegionDiskSettings = settings.testIamPermissionsRegionDiskSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSnapshotRegionDiskSettings, this.deleteRegionDiskSettings, this.getRegionDiskSettings, this.insertRegionDiskSettings, this.listRegionDisksSettings, this.resizeRegionDiskSettings, this.setLabelsRegionDiskSettings, this.testIamPermissionsRegionDiskSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSnapshotRegionDiskHttpRequest, Operation> createSnapshotRegionDiskSettings() {
            return this.createSnapshotRegionDiskSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegionDiskHttpRequest, Operation> deleteRegionDiskSettings() {
            return this.deleteRegionDiskSettings;
        }

        public UnaryCallSettings.Builder<GetRegionDiskHttpRequest, Disk> getRegionDiskSettings() {
            return this.getRegionDiskSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionDiskHttpRequest, Operation> insertRegionDiskSettings() {
            return this.insertRegionDiskSettings;
        }

        public PagedCallSettings.Builder<ListRegionDisksHttpRequest, DiskList, RegionDiskClient.ListRegionDisksPagedResponse> listRegionDisksSettings() {
            return this.listRegionDisksSettings;
        }

        public UnaryCallSettings.Builder<ResizeRegionDiskHttpRequest, Operation> resizeRegionDiskSettings() {
            return this.resizeRegionDiskSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsRegionDiskHttpRequest, Operation> setLabelsRegionDiskSettings() {
            return this.setLabelsRegionDiskSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRegionDiskHttpRequest, TestPermissionsResponse> testIamPermissionsRegionDiskSettings() {
            return this.testIamPermissionsRegionDiskSettings;
        }

        public RegionDiskStubSettings build() throws IOException {
            return new RegionDiskStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

