/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkEndpoint
implements ApiMessage {
    private final String instance;
    private final String ipAddress;
    private final Integer port;
    private static final NetworkEndpoint DEFAULT_INSTANCE = new NetworkEndpoint();

    private NetworkEndpoint() {
        this.instance = null;
        this.ipAddress = null;
        this.port = null;
    }

    private NetworkEndpoint(String instance, String ipAddress, Integer port) {
        this.instance = instance;
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public Object getFieldValue(String fieldName) {
        if ("instance".equals(fieldName)) {
            return this.instance;
        }
        if ("ipAddress".equals(fieldName)) {
            return this.ipAddress;
        }
        if ("port".equals(fieldName)) {
            return this.port;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkEndpoint prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkEndpoint getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkEndpoint{instance=" + this.instance + ", ipAddress=" + this.ipAddress + ", port=" + this.port + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkEndpoint) {
            NetworkEndpoint that = (NetworkEndpoint)o;
            return Objects.equals(this.instance, that.getInstance()) && Objects.equals(this.ipAddress, that.getIpAddress()) && Objects.equals(this.port, that.getPort());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.ipAddress, this.port);
    }

    public static class Builder {
        private String instance;
        private String ipAddress;
        private Integer port;

        Builder() {
        }

        public Builder mergeFrom(NetworkEndpoint other) {
            if (other == NetworkEndpoint.getDefaultInstance()) {
                return this;
            }
            if (other.getInstance() != null) {
                this.instance = other.instance;
            }
            if (other.getIpAddress() != null) {
                this.ipAddress = other.ipAddress;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            return this;
        }

        Builder(NetworkEndpoint source) {
            this.instance = source.instance;
            this.ipAddress = source.ipAddress;
            this.port = source.port;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public NetworkEndpoint build() {
            return new NetworkEndpoint(this.instance, this.ipAddress, this.port);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setInstance(this.instance);
            newBuilder.setIpAddress(this.ipAddress);
            newBuilder.setPort(this.port);
            return newBuilder;
        }
    }
}

