/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Expr
implements ApiMessage {
    private final String description;
    private final String expression;
    private final String location;
    private final String title;
    private static final Expr DEFAULT_INSTANCE = new Expr();

    private Expr() {
        this.description = null;
        this.expression = null;
        this.location = null;
        this.title = null;
    }

    private Expr(String description, String expression, String location, String title) {
        this.description = description;
        this.expression = expression;
        this.location = location;
        this.title = title;
    }

    public Object getFieldValue(String fieldName) {
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("expression".equals(fieldName)) {
            return this.expression;
        }
        if ("location".equals(fieldName)) {
            return this.location;
        }
        if ("title".equals(fieldName)) {
            return this.title;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTitle() {
        return this.title;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Expr prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Expr getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Expr{description=" + this.description + ", expression=" + this.expression + ", location=" + this.location + ", title=" + this.title + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Expr) {
            Expr that = (Expr)o;
            return Objects.equals(this.description, that.getDescription()) && Objects.equals(this.expression, that.getExpression()) && Objects.equals(this.location, that.getLocation()) && Objects.equals(this.title, that.getTitle());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.expression, this.location, this.title);
    }

    public static class Builder {
        private String description;
        private String expression;
        private String location;
        private String title;

        Builder() {
        }

        public Builder mergeFrom(Expr other) {
            if (other == Expr.getDefaultInstance()) {
                return this;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getExpression() != null) {
                this.expression = other.expression;
            }
            if (other.getLocation() != null) {
                this.location = other.location;
            }
            if (other.getTitle() != null) {
                this.title = other.title;
            }
            return this;
        }

        Builder(Expr source) {
            this.description = source.description;
            this.expression = source.expression;
            this.location = source.location;
            this.title = source.title;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getExpression() {
            return this.expression;
        }

        public Builder setExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Expr build() {
            return new Expr(this.description, this.expression, this.location, this.title);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDescription(this.description);
            newBuilder.setExpression(this.expression);
            newBuilder.setLocation(this.location);
            newBuilder.setTitle(this.title);
            return newBuilder;
        }
    }
}

