/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.AutoscalerAggregatedList;
import com.google.cloud.compute.v1.AutoscalerClient;
import com.google.cloud.compute.v1.AutoscalerList;
import com.google.cloud.compute.v1.AutoscalersScopedList;
import com.google.cloud.compute.v1.DeleteAutoscalerHttpRequest;
import com.google.cloud.compute.v1.GetAutoscalerHttpRequest;
import com.google.cloud.compute.v1.InsertAutoscalerHttpRequest;
import com.google.cloud.compute.v1.ListAutoscalersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchAutoscalerHttpRequest;
import com.google.cloud.compute.v1.UpdateAutoscalerHttpRequest;
import com.google.cloud.compute.v1.stub.AutoscalerStub;
import com.google.cloud.compute.v1.stub.HttpJsonAutoscalerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AutoscalerStubSettings
extends StubSettings<AutoscalerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalerClient.AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersSettings;
    private final UnaryCallSettings<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerSettings;
    private final UnaryCallSettings<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerSettings;
    private final UnaryCallSettings<InsertAutoscalerHttpRequest, Operation> insertAutoscalerSettings;
    private final PagedCallSettings<ListAutoscalersHttpRequest, AutoscalerList, AutoscalerClient.ListAutoscalersPagedResponse> listAutoscalersSettings;
    private final UnaryCallSettings<PatchAutoscalerHttpRequest, Operation> patchAutoscalerSettings;
    private final UnaryCallSettings<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerSettings;
    private static final PagedListDescriptor<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList> AGGREGATED_LIST_AUTOSCALERS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListAutoscalersHttpRequest injectToken(AggregatedListAutoscalersHttpRequest payload, String token) {
            return AggregatedListAutoscalersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListAutoscalersHttpRequest injectPageSize(AggregatedListAutoscalersHttpRequest payload, int pageSize) {
            return AggregatedListAutoscalersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListAutoscalersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AutoscalerAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AutoscalersScopedList> extractResources(AutoscalerAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler> LIST_AUTOSCALERS_PAGE_STR_DESC = new PagedListDescriptor<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler>(){

        public String emptyToken() {
            return "";
        }

        public ListAutoscalersHttpRequest injectToken(ListAutoscalersHttpRequest payload, String token) {
            return ListAutoscalersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListAutoscalersHttpRequest injectPageSize(ListAutoscalersHttpRequest payload, int pageSize) {
            return ListAutoscalersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListAutoscalersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AutoscalerList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Autoscaler> extractResources(AutoscalerList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalerClient.AggregatedListAutoscalersPagedResponse> AGGREGATED_LIST_AUTOSCALERS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalerClient.AggregatedListAutoscalersPagedResponse>(){

        public ApiFuture<AutoscalerClient.AggregatedListAutoscalersPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList> callable, AggregatedListAutoscalersHttpRequest request, ApiCallContext context, ApiFuture<AutoscalerAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_AUTOSCALERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoscalerClient.AggregatedListAutoscalersPagedResponse.createAsync((PageContext<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalersScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAutoscalersHttpRequest, AutoscalerList, AutoscalerClient.ListAutoscalersPagedResponse> LIST_AUTOSCALERS_PAGE_STR_FACT = new PagedListResponseFactory<ListAutoscalersHttpRequest, AutoscalerList, AutoscalerClient.ListAutoscalersPagedResponse>(){

        public ApiFuture<AutoscalerClient.ListAutoscalersPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutoscalersHttpRequest, AutoscalerList> callable, ListAutoscalersHttpRequest request, ApiCallContext context, ApiFuture<AutoscalerList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTOSCALERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoscalerClient.ListAutoscalersPagedResponse.createAsync((PageContext<ListAutoscalersHttpRequest, AutoscalerList, Autoscaler>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalerClient.AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersSettings() {
        return this.aggregatedListAutoscalersSettings;
    }

    public UnaryCallSettings<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerSettings() {
        return this.deleteAutoscalerSettings;
    }

    public UnaryCallSettings<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerSettings() {
        return this.getAutoscalerSettings;
    }

    public UnaryCallSettings<InsertAutoscalerHttpRequest, Operation> insertAutoscalerSettings() {
        return this.insertAutoscalerSettings;
    }

    public PagedCallSettings<ListAutoscalersHttpRequest, AutoscalerList, AutoscalerClient.ListAutoscalersPagedResponse> listAutoscalersSettings() {
        return this.listAutoscalersSettings;
    }

    public UnaryCallSettings<PatchAutoscalerHttpRequest, Operation> patchAutoscalerSettings() {
        return this.patchAutoscalerSettings;
    }

    public UnaryCallSettings<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerSettings() {
        return this.updateAutoscalerSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AutoscalerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAutoscalerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AutoscalerStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutoscalerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AutoscalerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListAutoscalersSettings = settingsBuilder.aggregatedListAutoscalersSettings().build();
        this.deleteAutoscalerSettings = settingsBuilder.deleteAutoscalerSettings().build();
        this.getAutoscalerSettings = settingsBuilder.getAutoscalerSettings().build();
        this.insertAutoscalerSettings = settingsBuilder.insertAutoscalerSettings().build();
        this.listAutoscalersSettings = settingsBuilder.listAutoscalersSettings().build();
        this.patchAutoscalerSettings = settingsBuilder.patchAutoscalerSettings().build();
        this.updateAutoscalerSettings = settingsBuilder.updateAutoscalerSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AutoscalerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalerClient.AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersSettings;
        private final UnaryCallSettings.Builder<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerSettings;
        private final UnaryCallSettings.Builder<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerSettings;
        private final UnaryCallSettings.Builder<InsertAutoscalerHttpRequest, Operation> insertAutoscalerSettings;
        private final PagedCallSettings.Builder<ListAutoscalersHttpRequest, AutoscalerList, AutoscalerClient.ListAutoscalersPagedResponse> listAutoscalersSettings;
        private final UnaryCallSettings.Builder<PatchAutoscalerHttpRequest, Operation> patchAutoscalerSettings;
        private final UnaryCallSettings.Builder<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListAutoscalersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_AUTOSCALERS_PAGE_STR_FACT);
            this.deleteAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAutoscalersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTOSCALERS_PAGE_STR_FACT);
            this.patchAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAutoscalerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListAutoscalersSettings, this.deleteAutoscalerSettings, this.getAutoscalerSettings, this.insertAutoscalerSettings, this.listAutoscalersSettings, this.patchAutoscalerSettings, this.updateAutoscalerSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AutoscalerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AutoscalerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AutoscalerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AutoscalerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListAutoscalersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listAutoscalersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateAutoscalerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(AutoscalerStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListAutoscalersSettings = settings.aggregatedListAutoscalersSettings.toBuilder();
            this.deleteAutoscalerSettings = settings.deleteAutoscalerSettings.toBuilder();
            this.getAutoscalerSettings = settings.getAutoscalerSettings.toBuilder();
            this.insertAutoscalerSettings = settings.insertAutoscalerSettings.toBuilder();
            this.listAutoscalersSettings = settings.listAutoscalersSettings.toBuilder();
            this.patchAutoscalerSettings = settings.patchAutoscalerSettings.toBuilder();
            this.updateAutoscalerSettings = settings.updateAutoscalerSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListAutoscalersSettings, this.deleteAutoscalerSettings, this.getAutoscalerSettings, this.insertAutoscalerSettings, this.listAutoscalersSettings, this.patchAutoscalerSettings, this.updateAutoscalerSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListAutoscalersHttpRequest, AutoscalerAggregatedList, AutoscalerClient.AggregatedListAutoscalersPagedResponse> aggregatedListAutoscalersSettings() {
            return this.aggregatedListAutoscalersSettings;
        }

        public UnaryCallSettings.Builder<DeleteAutoscalerHttpRequest, Operation> deleteAutoscalerSettings() {
            return this.deleteAutoscalerSettings;
        }

        public UnaryCallSettings.Builder<GetAutoscalerHttpRequest, Autoscaler> getAutoscalerSettings() {
            return this.getAutoscalerSettings;
        }

        public UnaryCallSettings.Builder<InsertAutoscalerHttpRequest, Operation> insertAutoscalerSettings() {
            return this.insertAutoscalerSettings;
        }

        public PagedCallSettings.Builder<ListAutoscalersHttpRequest, AutoscalerList, AutoscalerClient.ListAutoscalersPagedResponse> listAutoscalersSettings() {
            return this.listAutoscalersSettings;
        }

        public UnaryCallSettings.Builder<PatchAutoscalerHttpRequest, Operation> patchAutoscalerSettings() {
            return this.patchAutoscalerSettings;
        }

        public UnaryCallSettings.Builder<UpdateAutoscalerHttpRequest, Operation> updateAutoscalerSettings() {
            return this.updateAutoscalerSettings;
        }

        public AutoscalerStubSettings build() throws IOException {
            return new AutoscalerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

