/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.XpnResourceId;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ProjectsGetXpnResources
implements ApiMessage {
    private final String kind;
    private final String nextPageToken;
    private final List<XpnResourceId> resources;
    private static final ProjectsGetXpnResources DEFAULT_INSTANCE = new ProjectsGetXpnResources();

    private ProjectsGetXpnResources() {
        this.kind = null;
        this.nextPageToken = null;
        this.resources = null;
    }

    private ProjectsGetXpnResources(String kind, String nextPageToken, List<XpnResourceId> resources) {
        this.kind = kind;
        this.nextPageToken = nextPageToken;
        this.resources = resources;
    }

    public Object getFieldValue(String fieldName) {
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("nextPageToken".equals(fieldName)) {
            return this.nextPageToken;
        }
        if ("resources".equals(fieldName)) {
            return this.resources;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getKind() {
        return this.kind;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public List<XpnResourceId> getResourcesList() {
        return this.resources;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ProjectsGetXpnResources prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ProjectsGetXpnResources getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ProjectsGetXpnResources{kind=" + this.kind + ", nextPageToken=" + this.nextPageToken + ", resources=" + this.resources + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectsGetXpnResources) {
            ProjectsGetXpnResources that = (ProjectsGetXpnResources)o;
            return Objects.equals(this.kind, that.getKind()) && Objects.equals(this.nextPageToken, that.getNextPageToken()) && Objects.equals(this.resources, that.getResourcesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.nextPageToken, this.resources);
    }

    public static class Builder {
        private String kind;
        private String nextPageToken;
        private List<XpnResourceId> resources;

        Builder() {
        }

        public Builder mergeFrom(ProjectsGetXpnResources other) {
            if (other == ProjectsGetXpnResources.getDefaultInstance()) {
                return this;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getNextPageToken() != null) {
                this.nextPageToken = other.nextPageToken;
            }
            if (other.getResourcesList() != null) {
                this.resources = other.resources;
            }
            return this;
        }

        Builder(ProjectsGetXpnResources source) {
            this.kind = source.kind;
            this.nextPageToken = source.nextPageToken;
            this.resources = source.resources;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public List<XpnResourceId> getResourcesList() {
            return this.resources;
        }

        public Builder addAllResources(List<XpnResourceId> resources) {
            if (this.resources == null) {
                this.resources = new LinkedList<XpnResourceId>();
            }
            this.resources.addAll(resources);
            return this;
        }

        public Builder addResources(XpnResourceId resources) {
            if (this.resources == null) {
                this.resources = new LinkedList<XpnResourceId>();
            }
            this.resources.add(resources);
            return this;
        }

        public ProjectsGetXpnResources build() {
            return new ProjectsGetXpnResources(this.kind, this.nextPageToken, this.resources);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setKind(this.kind);
            newBuilder.setNextPageToken(this.nextPageToken);
            newBuilder.addAllResources(this.resources);
            return newBuilder;
        }
    }
}

