/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionOperationHttpRequest;
import com.google.cloud.compute.v1.GetRegionOperationHttpRequest;
import com.google.cloud.compute.v1.ListRegionOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionOperationName;
import com.google.cloud.compute.v1.RegionOperationSettings;
import com.google.cloud.compute.v1.stub.RegionOperationStub;
import com.google.cloud.compute.v1.stub.RegionOperationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionOperationClient
implements BackgroundResource {
    private final RegionOperationSettings settings;
    private final RegionOperationStub stub;

    public static final RegionOperationClient create() throws IOException {
        return RegionOperationClient.create(RegionOperationSettings.newBuilder().build());
    }

    public static final RegionOperationClient create(RegionOperationSettings settings) throws IOException {
        return new RegionOperationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionOperationClient create(RegionOperationStub stub) {
        return new RegionOperationClient(stub);
    }

    protected RegionOperationClient(RegionOperationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionOperationStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionOperationClient(RegionOperationStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionOperationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionOperationStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final void deleteRegionOperation(ProjectRegionOperationName operation) {
        DeleteRegionOperationHttpRequest request = DeleteRegionOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        this.deleteRegionOperation(request);
    }

    @BetaApi
    public final void deleteRegionOperation(String operation) {
        DeleteRegionOperationHttpRequest request = DeleteRegionOperationHttpRequest.newBuilder().setOperation(operation).build();
        this.deleteRegionOperation(request);
    }

    @BetaApi
    public final void deleteRegionOperation(DeleteRegionOperationHttpRequest request) {
        this.deleteRegionOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionOperationHttpRequest, Void> deleteRegionOperationCallable() {
        return this.stub.deleteRegionOperationCallable();
    }

    @BetaApi
    public final Operation getRegionOperation(ProjectRegionOperationName operation) {
        GetRegionOperationHttpRequest request = GetRegionOperationHttpRequest.newBuilder().setOperation(operation == null ? null : operation.toString()).build();
        return this.getRegionOperation(request);
    }

    @BetaApi
    public final Operation getRegionOperation(String operation) {
        GetRegionOperationHttpRequest request = GetRegionOperationHttpRequest.newBuilder().setOperation(operation).build();
        return this.getRegionOperation(request);
    }

    @BetaApi
    public final Operation getRegionOperation(GetRegionOperationHttpRequest request) {
        return (Operation)this.getRegionOperationCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionOperationHttpRequest, Operation> getRegionOperationCallable() {
        return this.stub.getRegionOperationCallable();
    }

    @BetaApi
    public final ListRegionOperationsPagedResponse listRegionOperations(ProjectRegionName region) {
        ListRegionOperationsHttpRequest request = ListRegionOperationsHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionOperations(request);
    }

    @BetaApi
    public final ListRegionOperationsPagedResponse listRegionOperations(String region) {
        ListRegionOperationsHttpRequest request = ListRegionOperationsHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionOperations(request);
    }

    @BetaApi
    public final ListRegionOperationsPagedResponse listRegionOperations(ListRegionOperationsHttpRequest request) {
        return (ListRegionOperationsPagedResponse)((Object)this.listRegionOperationsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionOperationsHttpRequest, ListRegionOperationsPagedResponse> listRegionOperationsPagedCallable() {
        return this.stub.listRegionOperationsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionOperationsHttpRequest, OperationList> listRegionOperationsCallable() {
        return this.stub.listRegionOperationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionOperationsHttpRequest, OperationList, Operation, ListRegionOperationsPage, ListRegionOperationsFixedSizeCollection> {
        private ListRegionOperationsFixedSizeCollection(List<ListRegionOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionOperationsFixedSizeCollection createEmptyCollection() {
            return new ListRegionOperationsFixedSizeCollection(null, 0);
        }

        protected ListRegionOperationsFixedSizeCollection createCollection(List<ListRegionOperationsPage> pages, int collectionSize) {
            return new ListRegionOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionOperationsPage
    extends AbstractPage<ListRegionOperationsHttpRequest, OperationList, Operation, ListRegionOperationsPage> {
        private ListRegionOperationsPage(PageContext<ListRegionOperationsHttpRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListRegionOperationsPage createEmptyPage() {
            return new ListRegionOperationsPage(null, null);
        }

        protected ListRegionOperationsPage createPage(PageContext<ListRegionOperationsHttpRequest, OperationList, Operation> context, OperationList response) {
            return new ListRegionOperationsPage(context, response);
        }

        public ApiFuture<ListRegionOperationsPage> createPageAsync(PageContext<ListRegionOperationsHttpRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionOperationsPagedResponse
    extends AbstractPagedListResponse<ListRegionOperationsHttpRequest, OperationList, Operation, ListRegionOperationsPage, ListRegionOperationsFixedSizeCollection> {
        public static ApiFuture<ListRegionOperationsPagedResponse> createAsync(PageContext<ListRegionOperationsHttpRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListRegionOperationsPage> futurePage = ListRegionOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionOperationsPage, ListRegionOperationsPagedResponse>(){

                public ListRegionOperationsPagedResponse apply(ListRegionOperationsPage input) {
                    return new ListRegionOperationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionOperationsPagedResponse(ListRegionOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionOperationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

