/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagerAutoHealingPolicy
implements ApiMessage {
    private final String healthCheck;
    private final Integer initialDelaySec;
    private static final InstanceGroupManagerAutoHealingPolicy DEFAULT_INSTANCE = new InstanceGroupManagerAutoHealingPolicy();

    private InstanceGroupManagerAutoHealingPolicy() {
        this.healthCheck = null;
        this.initialDelaySec = null;
    }

    private InstanceGroupManagerAutoHealingPolicy(String healthCheck, Integer initialDelaySec) {
        this.healthCheck = healthCheck;
        this.initialDelaySec = initialDelaySec;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("healthCheck")) {
            return this.healthCheck;
        }
        if (fieldName.equals("initialDelaySec")) {
            return this.initialDelaySec;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getHealthCheck() {
        return this.healthCheck;
    }

    public Integer getInitialDelaySec() {
        return this.initialDelaySec;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagerAutoHealingPolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagerAutoHealingPolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagerAutoHealingPolicy{healthCheck=" + this.healthCheck + ", initialDelaySec=" + this.initialDelaySec + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagerAutoHealingPolicy) {
            InstanceGroupManagerAutoHealingPolicy that = (InstanceGroupManagerAutoHealingPolicy)o;
            return Objects.equals(this.healthCheck, that.getHealthCheck()) && Objects.equals(this.initialDelaySec, that.getInitialDelaySec());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthCheck, this.initialDelaySec);
    }

    public static class Builder {
        private String healthCheck;
        private Integer initialDelaySec;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagerAutoHealingPolicy other) {
            if (other == InstanceGroupManagerAutoHealingPolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getHealthCheck() != null) {
                this.healthCheck = other.healthCheck;
            }
            if (other.getInitialDelaySec() != null) {
                this.initialDelaySec = other.initialDelaySec;
            }
            return this;
        }

        Builder(InstanceGroupManagerAutoHealingPolicy source) {
            this.healthCheck = source.healthCheck;
            this.initialDelaySec = source.initialDelaySec;
        }

        public String getHealthCheck() {
            return this.healthCheck;
        }

        public Builder setHealthCheck(String healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Integer getInitialDelaySec() {
            return this.initialDelaySec;
        }

        public Builder setInitialDelaySec(Integer initialDelaySec) {
            this.initialDelaySec = initialDelaySec;
            return this;
        }

        public InstanceGroupManagerAutoHealingPolicy build() {
            return new InstanceGroupManagerAutoHealingPolicy(this.healthCheck, this.initialDelaySec);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHealthCheck(this.healthCheck);
            newBuilder.setInitialDelaySec(this.initialDelaySec);
            return newBuilder;
        }
    }
}

