/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalUrlMapName
implements ResourceName {
    private final String project;
    private final String urlMap;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/urlMaps/{urlMap}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalUrlMapName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.urlMap = (String)Preconditions.checkNotNull((Object)builder.getUrlMap());
    }

    public static ProjectGlobalUrlMapName of(String project, String urlMap) {
        return ProjectGlobalUrlMapName.newBuilder().setProject(project).setUrlMap(urlMap).build();
    }

    public static String format(String project, String urlMap) {
        return ProjectGlobalUrlMapName.of(project, urlMap).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getUrlMap() {
        return this.urlMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalUrlMapName projectGlobalUrlMapName = this;
            synchronized (projectGlobalUrlMapName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"urlMap", (Object)this.urlMap);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalUrlMapName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalUrlMapName>(){

            public ProjectGlobalUrlMapName parse(String formattedString) {
                return ProjectGlobalUrlMapName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalUrlMapName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalUrlMapName.parse: formattedString not in valid format");
        return ProjectGlobalUrlMapName.of((String)matchMap.get("project"), (String)matchMap.get("urlMap"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "urlMap", this.urlMap});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalUrlMapName) {
            ProjectGlobalUrlMapName that = (ProjectGlobalUrlMapName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.urlMap, that.getUrlMap());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.urlMap);
    }

    public static class Builder {
        private String project;
        private String urlMap;

        public String getProject() {
            return this.project;
        }

        public String getUrlMap() {
            return this.urlMap;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setUrlMap(String urlMap) {
            this.urlMap = urlMap;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalUrlMapName projectGlobalUrlMapName) {
            this.project = projectGlobalUrlMapName.project;
            this.urlMap = projectGlobalUrlMapName.urlMap;
        }

        public ProjectGlobalUrlMapName build() {
            return new ProjectGlobalUrlMapName(this);
        }
    }
}

