/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalSslPolicyName
implements ResourceName {
    private final String project;
    private final String sslPolicy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/sslPolicies/{sslPolicy}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalSslPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.sslPolicy = (String)Preconditions.checkNotNull((Object)builder.getSslPolicy());
    }

    public static ProjectGlobalSslPolicyName of(String project, String sslPolicy) {
        return ProjectGlobalSslPolicyName.newBuilder().setProject(project).setSslPolicy(sslPolicy).build();
    }

    public static String format(String project, String sslPolicy) {
        return ProjectGlobalSslPolicyName.of(project, sslPolicy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getSslPolicy() {
        return this.sslPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalSslPolicyName projectGlobalSslPolicyName = this;
            synchronized (projectGlobalSslPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"sslPolicy", (Object)this.sslPolicy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalSslPolicyName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalSslPolicyName>(){

            public ProjectGlobalSslPolicyName parse(String formattedString) {
                return ProjectGlobalSslPolicyName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalSslPolicyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalSslPolicyName.parse: formattedString not in valid format");
        return ProjectGlobalSslPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("sslPolicy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "sslPolicy", this.sslPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalSslPolicyName) {
            ProjectGlobalSslPolicyName that = (ProjectGlobalSslPolicyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.sslPolicy, that.getSslPolicy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.sslPolicy);
    }

    public static class Builder {
        private String project;
        private String sslPolicy;

        public String getProject() {
            return this.project;
        }

        public String getSslPolicy() {
            return this.sslPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalSslPolicyName projectGlobalSslPolicyName) {
            this.project = projectGlobalSslPolicyName.project;
            this.sslPolicy = projectGlobalSslPolicyName.sslPolicy;
        }

        public ProjectGlobalSslPolicyName build() {
            return new ProjectGlobalSslPolicyName(this);
        }
    }
}

