/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Expr;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Binding
implements ApiMessage {
    private final Expr condition;
    private final List<String> members;
    private final String role;
    private static final Binding DEFAULT_INSTANCE = new Binding();

    private Binding() {
        this.condition = null;
        this.members = null;
        this.role = null;
    }

    private Binding(Expr condition, List<String> members, String role) {
        this.condition = condition;
        this.members = members;
        this.role = role;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("condition")) {
            return this.condition;
        }
        if (fieldName.equals("members")) {
            return this.members;
        }
        if (fieldName.equals("role")) {
            return this.role;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Expr getCondition() {
        return this.condition;
    }

    public List<String> getMembersList() {
        return this.members;
    }

    public String getRole() {
        return this.role;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Binding prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Binding getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Binding{condition=" + this.condition + ", members=" + this.members + ", role=" + this.role + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Binding) {
            Binding that = (Binding)o;
            return Objects.equals(this.condition, that.getCondition()) && Objects.equals(this.members, that.getMembersList()) && Objects.equals(this.role, that.getRole());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.members, this.role);
    }

    public static class Builder {
        private Expr condition;
        private List<String> members;
        private String role;

        Builder() {
        }

        public Builder mergeFrom(Binding other) {
            if (other == Binding.getDefaultInstance()) {
                return this;
            }
            if (other.getCondition() != null) {
                this.condition = other.condition;
            }
            if (other.getMembersList() != null) {
                this.members = other.members;
            }
            if (other.getRole() != null) {
                this.role = other.role;
            }
            return this;
        }

        Builder(Binding source) {
            this.condition = source.condition;
            this.members = source.members;
            this.role = source.role;
        }

        public Expr getCondition() {
            return this.condition;
        }

        public Builder setCondition(Expr condition) {
            this.condition = condition;
            return this;
        }

        public List<String> getMembersList() {
            return this.members;
        }

        public Builder addAllMembers(List<String> members) {
            if (this.members == null) {
                this.members = new LinkedList<String>();
            }
            this.members.addAll(members);
            return this;
        }

        public Builder addMembers(String members) {
            if (this.members == null) {
                this.members = new LinkedList<String>();
            }
            this.members.add(members);
            return this;
        }

        public String getRole() {
            return this.role;
        }

        public Builder setRole(String role) {
            this.role = role;
            return this;
        }

        public Binding build() {
            return new Binding(this.condition, this.members, this.role);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCondition(this.condition);
            newBuilder.addAllMembers(this.members);
            newBuilder.setRole(this.role);
            return newBuilder;
        }
    }
}

