/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteLicenseHttpRequest;
import com.google.cloud.compute.v1.GetLicenseHttpRequest;
import com.google.cloud.compute.v1.InsertLicenseHttpRequest;
import com.google.cloud.compute.v1.License;
import com.google.cloud.compute.v1.LicenseSettings;
import com.google.cloud.compute.v1.LicensesListResponse;
import com.google.cloud.compute.v1.ListLicensesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalLicenseName;
import com.google.cloud.compute.v1.ProjectGlobalLicenseResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.TestIamPermissionsLicenseHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.LicenseStub;
import com.google.cloud.compute.v1.stub.LicenseStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LicenseClient
implements BackgroundResource {
    private final LicenseSettings settings;
    private final LicenseStub stub;

    public static final LicenseClient create() throws IOException {
        return LicenseClient.create(LicenseSettings.newBuilder().build());
    }

    public static final LicenseClient create(LicenseSettings settings) throws IOException {
        return new LicenseClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LicenseClient create(LicenseStub stub) {
        return new LicenseClient(stub);
    }

    protected LicenseClient(LicenseSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LicenseStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LicenseClient(LicenseStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LicenseSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LicenseStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteLicense(ProjectGlobalLicenseName license) {
        DeleteLicenseHttpRequest request = DeleteLicenseHttpRequest.newBuilder().setLicense(license == null ? null : license.toString()).build();
        return this.deleteLicense(request);
    }

    @BetaApi
    public final Operation deleteLicense(String license) {
        DeleteLicenseHttpRequest request = DeleteLicenseHttpRequest.newBuilder().setLicense(license).build();
        return this.deleteLicense(request);
    }

    @BetaApi
    public final Operation deleteLicense(DeleteLicenseHttpRequest request) {
        return (Operation)this.deleteLicenseCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteLicenseHttpRequest, Operation> deleteLicenseCallable() {
        return this.stub.deleteLicenseCallable();
    }

    @BetaApi
    public final License getLicense(ProjectGlobalLicenseName license) {
        GetLicenseHttpRequest request = GetLicenseHttpRequest.newBuilder().setLicense(license == null ? null : license.toString()).build();
        return this.getLicense(request);
    }

    @BetaApi
    public final License getLicense(String license) {
        GetLicenseHttpRequest request = GetLicenseHttpRequest.newBuilder().setLicense(license).build();
        return this.getLicense(request);
    }

    @BetaApi
    public final License getLicense(GetLicenseHttpRequest request) {
        return (License)this.getLicenseCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetLicenseHttpRequest, License> getLicenseCallable() {
        return this.stub.getLicenseCallable();
    }

    @BetaApi
    public final Operation insertLicense(ProjectName project, License licenseResource) {
        InsertLicenseHttpRequest request = InsertLicenseHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setLicenseResource(licenseResource).build();
        return this.insertLicense(request);
    }

    @BetaApi
    public final Operation insertLicense(String project, License licenseResource) {
        InsertLicenseHttpRequest request = InsertLicenseHttpRequest.newBuilder().setProject(project).setLicenseResource(licenseResource).build();
        return this.insertLicense(request);
    }

    @BetaApi
    public final Operation insertLicense(InsertLicenseHttpRequest request) {
        return (Operation)this.insertLicenseCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertLicenseHttpRequest, Operation> insertLicenseCallable() {
        return this.stub.insertLicenseCallable();
    }

    @BetaApi
    public final ListLicensesPagedResponse listLicenses(ProjectName project) {
        ListLicensesHttpRequest request = ListLicensesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listLicenses(request);
    }

    @BetaApi
    public final ListLicensesPagedResponse listLicenses(String project) {
        ListLicensesHttpRequest request = ListLicensesHttpRequest.newBuilder().setProject(project).build();
        return this.listLicenses(request);
    }

    @BetaApi
    public final ListLicensesPagedResponse listLicenses(ListLicensesHttpRequest request) {
        return (ListLicensesPagedResponse)((Object)this.listLicensesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListLicensesHttpRequest, ListLicensesPagedResponse> listLicensesPagedCallable() {
        return this.stub.listLicensesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListLicensesHttpRequest, LicensesListResponse> listLicensesCallable() {
        return this.stub.listLicensesCallable();
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsLicense(ProjectGlobalLicenseResourceName resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsLicenseHttpRequest request = TestIamPermissionsLicenseHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsLicense(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsLicense(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsLicenseHttpRequest request = TestIamPermissionsLicenseHttpRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissionsLicense(request);
    }

    @BetaApi
    public final TestPermissionsResponse testIamPermissionsLicense(TestIamPermissionsLicenseHttpRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsLicenseCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<TestIamPermissionsLicenseHttpRequest, TestPermissionsResponse> testIamPermissionsLicenseCallable() {
        return this.stub.testIamPermissionsLicenseCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLicensesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLicensesHttpRequest, LicensesListResponse, License, ListLicensesPage, ListLicensesFixedSizeCollection> {
        private ListLicensesFixedSizeCollection(List<ListLicensesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLicensesFixedSizeCollection createEmptyCollection() {
            return new ListLicensesFixedSizeCollection(null, 0);
        }

        protected ListLicensesFixedSizeCollection createCollection(List<ListLicensesPage> pages, int collectionSize) {
            return new ListLicensesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLicensesPage
    extends AbstractPage<ListLicensesHttpRequest, LicensesListResponse, License, ListLicensesPage> {
        private ListLicensesPage(PageContext<ListLicensesHttpRequest, LicensesListResponse, License> context, LicensesListResponse response) {
            super(context, (Object)response);
        }

        private static ListLicensesPage createEmptyPage() {
            return new ListLicensesPage(null, null);
        }

        protected ListLicensesPage createPage(PageContext<ListLicensesHttpRequest, LicensesListResponse, License> context, LicensesListResponse response) {
            return new ListLicensesPage(context, response);
        }

        public ApiFuture<ListLicensesPage> createPageAsync(PageContext<ListLicensesHttpRequest, LicensesListResponse, License> context, ApiFuture<LicensesListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLicensesPagedResponse
    extends AbstractPagedListResponse<ListLicensesHttpRequest, LicensesListResponse, License, ListLicensesPage, ListLicensesFixedSizeCollection> {
        public static ApiFuture<ListLicensesPagedResponse> createAsync(PageContext<ListLicensesHttpRequest, LicensesListResponse, License> context, ApiFuture<LicensesListResponse> futureResponse) {
            ApiFuture<ListLicensesPage> futurePage = ListLicensesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListLicensesPage, ListLicensesPagedResponse>(){

                public ListLicensesPagedResponse apply(ListLicensesPage input) {
                    return new ListLicensesPagedResponse(input);
                }
            });
        }

        private ListLicensesPagedResponse(ListLicensesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLicensesFixedSizeCollection.createEmptyCollection());
        }
    }
}

