/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteInterconnectHttpRequest;
import com.google.cloud.compute.v1.GetInterconnectHttpRequest;
import com.google.cloud.compute.v1.InsertInterconnectHttpRequest;
import com.google.cloud.compute.v1.Interconnect;
import com.google.cloud.compute.v1.InterconnectClient;
import com.google.cloud.compute.v1.InterconnectList;
import com.google.cloud.compute.v1.ListInterconnectsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInterconnectStub;
import com.google.cloud.compute.v1.stub.InterconnectStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InterconnectStubSettings
extends StubSettings<InterconnectStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteInterconnectHttpRequest, Operation> deleteInterconnectSettings;
    private final UnaryCallSettings<GetInterconnectHttpRequest, Interconnect> getInterconnectSettings;
    private final UnaryCallSettings<InsertInterconnectHttpRequest, Operation> insertInterconnectSettings;
    private final PagedCallSettings<ListInterconnectsHttpRequest, InterconnectList, InterconnectClient.ListInterconnectsPagedResponse> listInterconnectsSettings;
    private final UnaryCallSettings<PatchInterconnectHttpRequest, Operation> patchInterconnectSettings;
    private static final PagedListDescriptor<ListInterconnectsHttpRequest, InterconnectList, Interconnect> LIST_INTERCONNECTS_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectsHttpRequest, InterconnectList, Interconnect>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectsHttpRequest injectToken(ListInterconnectsHttpRequest payload, String token) {
            return ListInterconnectsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInterconnectsHttpRequest injectPageSize(ListInterconnectsHttpRequest payload, int pageSize) {
            return ListInterconnectsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InterconnectList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Interconnect> extractResources(InterconnectList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListInterconnectsHttpRequest, InterconnectList, InterconnectClient.ListInterconnectsPagedResponse> LIST_INTERCONNECTS_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectsHttpRequest, InterconnectList, InterconnectClient.ListInterconnectsPagedResponse>(){

        public ApiFuture<InterconnectClient.ListInterconnectsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectsHttpRequest, InterconnectList> callable, ListInterconnectsHttpRequest request, ApiCallContext context, ApiFuture<InterconnectList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTERCONNECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InterconnectClient.ListInterconnectsPagedResponse.createAsync((PageContext<ListInterconnectsHttpRequest, InterconnectList, Interconnect>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteInterconnectHttpRequest, Operation> deleteInterconnectSettings() {
        return this.deleteInterconnectSettings;
    }

    public UnaryCallSettings<GetInterconnectHttpRequest, Interconnect> getInterconnectSettings() {
        return this.getInterconnectSettings;
    }

    public UnaryCallSettings<InsertInterconnectHttpRequest, Operation> insertInterconnectSettings() {
        return this.insertInterconnectSettings;
    }

    public PagedCallSettings<ListInterconnectsHttpRequest, InterconnectList, InterconnectClient.ListInterconnectsPagedResponse> listInterconnectsSettings() {
        return this.listInterconnectsSettings;
    }

    public UnaryCallSettings<PatchInterconnectHttpRequest, Operation> patchInterconnectSettings() {
        return this.patchInterconnectSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInterconnectStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InterconnectStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InterconnectStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InterconnectStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteInterconnectSettings = settingsBuilder.deleteInterconnectSettings().build();
        this.getInterconnectSettings = settingsBuilder.getInterconnectSettings().build();
        this.insertInterconnectSettings = settingsBuilder.insertInterconnectSettings().build();
        this.listInterconnectsSettings = settingsBuilder.listInterconnectsSettings().build();
        this.patchInterconnectSettings = settingsBuilder.patchInterconnectSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InterconnectStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteInterconnectHttpRequest, Operation> deleteInterconnectSettings;
        private final UnaryCallSettings.Builder<GetInterconnectHttpRequest, Interconnect> getInterconnectSettings;
        private final UnaryCallSettings.Builder<InsertInterconnectHttpRequest, Operation> insertInterconnectSettings;
        private final PagedCallSettings.Builder<ListInterconnectsHttpRequest, InterconnectList, InterconnectClient.ListInterconnectsPagedResponse> listInterconnectsSettings;
        private final UnaryCallSettings.Builder<PatchInterconnectHttpRequest, Operation> patchInterconnectSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteInterconnectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInterconnectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertInterconnectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInterconnectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTERCONNECTS_PAGE_STR_FACT);
            this.patchInterconnectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteInterconnectSettings, this.getInterconnectSettings, this.insertInterconnectSettings, this.listInterconnectsSettings, this.patchInterconnectSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InterconnectStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InterconnectStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InterconnectStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InterconnectStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteInterconnectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInterconnectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertInterconnectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInterconnectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchInterconnectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InterconnectStubSettings settings) {
            super((StubSettings)settings);
            this.deleteInterconnectSettings = settings.deleteInterconnectSettings.toBuilder();
            this.getInterconnectSettings = settings.getInterconnectSettings.toBuilder();
            this.insertInterconnectSettings = settings.insertInterconnectSettings.toBuilder();
            this.listInterconnectsSettings = settings.listInterconnectsSettings.toBuilder();
            this.patchInterconnectSettings = settings.patchInterconnectSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteInterconnectSettings, this.getInterconnectSettings, this.insertInterconnectSettings, this.listInterconnectsSettings, this.patchInterconnectSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteInterconnectHttpRequest, Operation> deleteInterconnectSettings() {
            return this.deleteInterconnectSettings;
        }

        public UnaryCallSettings.Builder<GetInterconnectHttpRequest, Interconnect> getInterconnectSettings() {
            return this.getInterconnectSettings;
        }

        public UnaryCallSettings.Builder<InsertInterconnectHttpRequest, Operation> insertInterconnectSettings() {
            return this.insertInterconnectSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectsHttpRequest, InterconnectList, InterconnectClient.ListInterconnectsPagedResponse> listInterconnectsSettings() {
            return this.listInterconnectsSettings;
        }

        public UnaryCallSettings.Builder<PatchInterconnectHttpRequest, Operation> patchInterconnectSettings() {
            return this.patchInterconnectSettings;
        }

        public InterconnectStubSettings build() throws IOException {
            return new InterconnectStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

