/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.AutoscalerStatusDetails;
import com.google.cloud.compute.v1.AutoscalingPolicy;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Autoscaler
implements ApiMessage {
    private final AutoscalingPolicy autoscalingPolicy;
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String kind;
    private final String name;
    private final String region;
    private final String selfLink;
    private final String status;
    private final List<AutoscalerStatusDetails> statusDetails;
    private final String target;
    private final String zone;
    private static final Autoscaler DEFAULT_INSTANCE = new Autoscaler();

    private Autoscaler() {
        this.autoscalingPolicy = null;
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.region = null;
        this.selfLink = null;
        this.status = null;
        this.statusDetails = null;
        this.target = null;
        this.zone = null;
    }

    private Autoscaler(AutoscalingPolicy autoscalingPolicy, String creationTimestamp, String description, String id, String kind, String name, String region, String selfLink, String status, List<AutoscalerStatusDetails> statusDetails, String target, String zone) {
        this.autoscalingPolicy = autoscalingPolicy;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.region = region;
        this.selfLink = selfLink;
        this.status = status;
        this.statusDetails = statusDetails;
        this.target = target;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("autoscalingPolicy")) {
            return this.autoscalingPolicy;
        }
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("region")) {
            return this.region;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        if (fieldName.equals("status")) {
            return this.status;
        }
        if (fieldName.equals("statusDetails")) {
            return this.statusDetails;
        }
        if (fieldName.equals("target")) {
            return this.target;
        }
        if (fieldName.equals("zone")) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public AutoscalingPolicy getAutoscalingPolicy() {
        return this.autoscalingPolicy;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getStatus() {
        return this.status;
    }

    public List<AutoscalerStatusDetails> getStatusDetailsList() {
        return this.statusDetails;
    }

    public String getTarget() {
        return this.target;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Autoscaler prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Autoscaler getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Autoscaler{autoscalingPolicy=" + this.autoscalingPolicy + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", region=" + this.region + ", selfLink=" + this.selfLink + ", status=" + this.status + ", statusDetails=" + this.statusDetails + ", target=" + this.target + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Autoscaler) {
            Autoscaler that = (Autoscaler)o;
            return Objects.equals(this.autoscalingPolicy, that.getAutoscalingPolicy()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.statusDetails, that.getStatusDetailsList()) && Objects.equals(this.target, that.getTarget()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoscalingPolicy, this.creationTimestamp, this.description, this.id, this.kind, this.name, this.region, this.selfLink, this.status, this.statusDetails, this.target, this.zone);
    }

    public static class Builder {
        private AutoscalingPolicy autoscalingPolicy;
        private String creationTimestamp;
        private String description;
        private String id;
        private String kind;
        private String name;
        private String region;
        private String selfLink;
        private String status;
        private List<AutoscalerStatusDetails> statusDetails;
        private String target;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(Autoscaler other) {
            if (other == Autoscaler.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoscalingPolicy() != null) {
                this.autoscalingPolicy = other.autoscalingPolicy;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getStatusDetailsList() != null) {
                this.statusDetails = other.statusDetails;
            }
            if (other.getTarget() != null) {
                this.target = other.target;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(Autoscaler source) {
            this.autoscalingPolicy = source.autoscalingPolicy;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.status = source.status;
            this.statusDetails = source.statusDetails;
            this.target = source.target;
            this.zone = source.zone;
        }

        public AutoscalingPolicy getAutoscalingPolicy() {
            return this.autoscalingPolicy;
        }

        public Builder setAutoscalingPolicy(AutoscalingPolicy autoscalingPolicy) {
            this.autoscalingPolicy = autoscalingPolicy;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public List<AutoscalerStatusDetails> getStatusDetailsList() {
            return this.statusDetails;
        }

        public Builder addAllStatusDetails(List<AutoscalerStatusDetails> statusDetails) {
            if (this.statusDetails == null) {
                this.statusDetails = new LinkedList<AutoscalerStatusDetails>();
            }
            this.statusDetails.addAll(statusDetails);
            return this;
        }

        public Builder addStatusDetails(AutoscalerStatusDetails statusDetails) {
            if (this.statusDetails == null) {
                this.statusDetails = new LinkedList<AutoscalerStatusDetails>();
            }
            this.statusDetails.add(statusDetails);
            return this;
        }

        public String getTarget() {
            return this.target;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Autoscaler build() {
            return new Autoscaler(this.autoscalingPolicy, this.creationTimestamp, this.description, this.id, this.kind, this.name, this.region, this.selfLink, this.status, this.statusDetails, this.target, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoscalingPolicy(this.autoscalingPolicy);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setStatus(this.status);
            newBuilder.addAllStatusDetails(this.statusDetails);
            newBuilder.setTarget(this.target);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

