/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HealthStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetPoolInstanceHealth
implements ApiMessage {
    private final List<HealthStatus> healthStatus;
    private final String kind;
    private static final TargetPoolInstanceHealth DEFAULT_INSTANCE = new TargetPoolInstanceHealth();

    private TargetPoolInstanceHealth() {
        this.healthStatus = null;
        this.kind = null;
    }

    private TargetPoolInstanceHealth(List<HealthStatus> healthStatus, String kind) {
        this.healthStatus = healthStatus;
        this.kind = kind;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("healthStatus")) {
            return this.healthStatus;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<HealthStatus> getHealthStatusList() {
        return this.healthStatus;
    }

    public String getKind() {
        return this.kind;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetPoolInstanceHealth prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetPoolInstanceHealth getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetPoolInstanceHealth{healthStatus=" + this.healthStatus + ", kind=" + this.kind + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetPoolInstanceHealth) {
            TargetPoolInstanceHealth that = (TargetPoolInstanceHealth)o;
            return Objects.equals(this.healthStatus, that.getHealthStatusList()) && Objects.equals(this.kind, that.getKind());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.healthStatus, this.kind);
    }

    public static class Builder {
        private List<HealthStatus> healthStatus;
        private String kind;

        Builder() {
        }

        public Builder mergeFrom(TargetPoolInstanceHealth other) {
            if (other == TargetPoolInstanceHealth.getDefaultInstance()) {
                return this;
            }
            if (other.getHealthStatusList() != null) {
                this.healthStatus = other.healthStatus;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            return this;
        }

        Builder(TargetPoolInstanceHealth source) {
            this.healthStatus = source.healthStatus;
            this.kind = source.kind;
        }

        public List<HealthStatus> getHealthStatusList() {
            return this.healthStatus;
        }

        public Builder addAllHealthStatus(List<HealthStatus> healthStatus) {
            if (this.healthStatus == null) {
                this.healthStatus = new LinkedList<HealthStatus>();
            }
            this.healthStatus.addAll(healthStatus);
            return this;
        }

        public Builder addHealthStatus(HealthStatus healthStatus) {
            if (this.healthStatus == null) {
                this.healthStatus = new LinkedList<HealthStatus>();
            }
            this.healthStatus.add(healthStatus);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public TargetPoolInstanceHealth build() {
            return new TargetPoolInstanceHealth(this.healthStatus, this.kind);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllHealthStatus(this.healthStatus);
            newBuilder.setKind(this.kind);
            return newBuilder;
        }
    }
}

