/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NodeGroupNode
implements ApiMessage {
    private final List<String> instances;
    private final String name;
    private final String nodeType;
    private final String status;
    private static final NodeGroupNode DEFAULT_INSTANCE = new NodeGroupNode();

    private NodeGroupNode() {
        this.instances = null;
        this.name = null;
        this.nodeType = null;
        this.status = null;
    }

    private NodeGroupNode(List<String> instances, String name, String nodeType, String status) {
        this.instances = instances;
        this.name = name;
        this.nodeType = nodeType;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("instances")) {
            return this.instances;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("nodeType")) {
            return this.nodeType;
        }
        if (fieldName.equals("status")) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getInstancesList() {
        return this.instances;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeGroupNode prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NodeGroupNode getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NodeGroupNode{instances=" + this.instances + ", name=" + this.name + ", nodeType=" + this.nodeType + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeGroupNode) {
            NodeGroupNode that = (NodeGroupNode)o;
            return Objects.equals(this.instances, that.getInstancesList()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.nodeType, that.getNodeType()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instances, this.name, this.nodeType, this.status);
    }

    public static class Builder {
        private List<String> instances;
        private String name;
        private String nodeType;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(NodeGroupNode other) {
            if (other == NodeGroupNode.getDefaultInstance()) {
                return this;
            }
            if (other.getInstancesList() != null) {
                this.instances = other.instances;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNodeType() != null) {
                this.nodeType = other.nodeType;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(NodeGroupNode source) {
            this.instances = source.instances;
            this.name = source.name;
            this.nodeType = source.nodeType;
            this.status = source.status;
        }

        public List<String> getInstancesList() {
            return this.instances;
        }

        public Builder addAllInstances(List<String> instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.addAll(instances);
            return this;
        }

        public Builder addInstances(String instances) {
            if (this.instances == null) {
                this.instances = new LinkedList<String>();
            }
            this.instances.add(instances);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Builder setNodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public NodeGroupNode build() {
            return new NodeGroupNode(this.instances, this.name, this.nodeType, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllInstances(this.instances);
            newBuilder.setName(this.name);
            newBuilder.setNodeType(this.nodeType);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

