/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.DisksResizeRequest;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResizeDiskHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final String disk;
    private final DisksResizeRequest disksResizeRequestResource;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String requestId;
    private final String userIp;
    private static final ResizeDiskHttpRequest DEFAULT_INSTANCE = new ResizeDiskHttpRequest();

    private ResizeDiskHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.disk = null;
        this.disksResizeRequestResource = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.requestId = null;
        this.userIp = null;
    }

    private ResizeDiskHttpRequest(String access_token, String callback, String disk, DisksResizeRequest disksResizeRequestResource, String fields, String key, String prettyPrint, String quotaUser, String requestId, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.disk = disk;
        this.disksResizeRequestResource = disksResizeRequestResource;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("disk")) {
            return this.disk;
        }
        if (fieldName.equals("disksResizeRequestResource")) {
            return this.disksResizeRequestResource;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("requestId")) {
            return this.requestId;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public DisksResizeRequest getApiMessageRequestBody() {
        return this.disksResizeRequestResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getDisk() {
        return this.disk;
    }

    public DisksResizeRequest getDisksResizeRequestResource() {
        return this.disksResizeRequestResource;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResizeDiskHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResizeDiskHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResizeDiskHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", disk=" + this.disk + ", disksResizeRequestResource=" + this.disksResizeRequestResource + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResizeDiskHttpRequest) {
            ResizeDiskHttpRequest that = (ResizeDiskHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.disk, that.getDisk()) && Objects.equals(this.disksResizeRequestResource, that.getDisksResizeRequestResource()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.disk, this.disksResizeRequestResource, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private String disk;
        private DisksResizeRequest disksResizeRequestResource;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String requestId;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(ResizeDiskHttpRequest other) {
            if (other == ResizeDiskHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getDisk() != null) {
                this.disk = other.disk;
            }
            if (other.getDisksResizeRequestResource() != null) {
                this.disksResizeRequestResource = other.disksResizeRequestResource;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(ResizeDiskHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.disk = source.disk;
            this.disksResizeRequestResource = source.disksResizeRequestResource;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getDisk() {
            return this.disk;
        }

        public Builder setDisk(String disk) {
            this.disk = disk;
            return this;
        }

        public DisksResizeRequest getDisksResizeRequestResource() {
            return this.disksResizeRequestResource;
        }

        public Builder setDisksResizeRequestResource(DisksResizeRequest disksResizeRequestResource) {
            this.disksResizeRequestResource = disksResizeRequestResource;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public ResizeDiskHttpRequest build() {
            String missing = "";
            if (this.disk == null) {
                missing = missing + " disk";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new ResizeDiskHttpRequest(this.access_token, this.callback, this.disk, this.disksResizeRequestResource, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setDisk(this.disk);
            newBuilder.setDisksResizeRequestResource(this.disksResizeRequestResource);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

