/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DisableXpnHostProjectHttpRequest;
import com.google.cloud.compute.v1.DisableXpnResourceProjectHttpRequest;
import com.google.cloud.compute.v1.DiskMoveRequest;
import com.google.cloud.compute.v1.EnableXpnHostProjectHttpRequest;
import com.google.cloud.compute.v1.EnableXpnResourceProjectHttpRequest;
import com.google.cloud.compute.v1.GetProjectHttpRequest;
import com.google.cloud.compute.v1.GetXpnHostProjectHttpRequest;
import com.google.cloud.compute.v1.GetXpnResourcesProjectsHttpRequest;
import com.google.cloud.compute.v1.InstanceMoveRequest;
import com.google.cloud.compute.v1.ListXpnHostsProjectsHttpRequest;
import com.google.cloud.compute.v1.Metadata;
import com.google.cloud.compute.v1.MoveDiskProjectHttpRequest;
import com.google.cloud.compute.v1.MoveInstanceProjectHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Project;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectSettings;
import com.google.cloud.compute.v1.ProjectsDisableXpnResourceRequest;
import com.google.cloud.compute.v1.ProjectsEnableXpnResourceRequest;
import com.google.cloud.compute.v1.ProjectsGetXpnResources;
import com.google.cloud.compute.v1.ProjectsListXpnHostsRequest;
import com.google.cloud.compute.v1.ProjectsSetDefaultNetworkTierRequest;
import com.google.cloud.compute.v1.SetCommonInstanceMetadataProjectHttpRequest;
import com.google.cloud.compute.v1.SetDefaultNetworkTierProjectHttpRequest;
import com.google.cloud.compute.v1.SetUsageExportBucketProjectHttpRequest;
import com.google.cloud.compute.v1.UsageExportLocation;
import com.google.cloud.compute.v1.XpnHostList;
import com.google.cloud.compute.v1.XpnResourceId;
import com.google.cloud.compute.v1.stub.ProjectStub;
import com.google.cloud.compute.v1.stub.ProjectStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProjectClient
implements BackgroundResource {
    private final ProjectSettings settings;
    private final ProjectStub stub;

    public static final ProjectClient create() throws IOException {
        return ProjectClient.create(ProjectSettings.newBuilder().build());
    }

    public static final ProjectClient create(ProjectSettings settings) throws IOException {
        return new ProjectClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProjectClient create(ProjectStub stub) {
        return new ProjectClient(stub);
    }

    protected ProjectClient(ProjectSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProjectClient(ProjectStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProjectSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProjectStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation disableXpnHostProject(ProjectName project) {
        DisableXpnHostProjectHttpRequest request = DisableXpnHostProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.disableXpnHostProject(request);
    }

    @BetaApi
    public final Operation disableXpnHostProject(String project) {
        DisableXpnHostProjectHttpRequest request = DisableXpnHostProjectHttpRequest.newBuilder().setProject(project).build();
        return this.disableXpnHostProject(request);
    }

    @BetaApi
    public final Operation disableXpnHostProject(DisableXpnHostProjectHttpRequest request) {
        return (Operation)this.disableXpnHostProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DisableXpnHostProjectHttpRequest, Operation> disableXpnHostProjectCallable() {
        return this.stub.disableXpnHostProjectCallable();
    }

    @BetaApi
    public final Operation disableXpnResourceProject(ProjectName project, ProjectsDisableXpnResourceRequest projectsDisableXpnResourceRequestResource) {
        DisableXpnResourceProjectHttpRequest request = DisableXpnResourceProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setProjectsDisableXpnResourceRequestResource(projectsDisableXpnResourceRequestResource).build();
        return this.disableXpnResourceProject(request);
    }

    @BetaApi
    public final Operation disableXpnResourceProject(String project, ProjectsDisableXpnResourceRequest projectsDisableXpnResourceRequestResource) {
        DisableXpnResourceProjectHttpRequest request = DisableXpnResourceProjectHttpRequest.newBuilder().setProject(project).setProjectsDisableXpnResourceRequestResource(projectsDisableXpnResourceRequestResource).build();
        return this.disableXpnResourceProject(request);
    }

    @BetaApi
    public final Operation disableXpnResourceProject(DisableXpnResourceProjectHttpRequest request) {
        return (Operation)this.disableXpnResourceProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DisableXpnResourceProjectHttpRequest, Operation> disableXpnResourceProjectCallable() {
        return this.stub.disableXpnResourceProjectCallable();
    }

    @BetaApi
    public final Operation enableXpnHostProject(ProjectName project) {
        EnableXpnHostProjectHttpRequest request = EnableXpnHostProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.enableXpnHostProject(request);
    }

    @BetaApi
    public final Operation enableXpnHostProject(String project) {
        EnableXpnHostProjectHttpRequest request = EnableXpnHostProjectHttpRequest.newBuilder().setProject(project).build();
        return this.enableXpnHostProject(request);
    }

    @BetaApi
    public final Operation enableXpnHostProject(EnableXpnHostProjectHttpRequest request) {
        return (Operation)this.enableXpnHostProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<EnableXpnHostProjectHttpRequest, Operation> enableXpnHostProjectCallable() {
        return this.stub.enableXpnHostProjectCallable();
    }

    @BetaApi
    public final Operation enableXpnResourceProject(ProjectName project, ProjectsEnableXpnResourceRequest projectsEnableXpnResourceRequestResource) {
        EnableXpnResourceProjectHttpRequest request = EnableXpnResourceProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setProjectsEnableXpnResourceRequestResource(projectsEnableXpnResourceRequestResource).build();
        return this.enableXpnResourceProject(request);
    }

    @BetaApi
    public final Operation enableXpnResourceProject(String project, ProjectsEnableXpnResourceRequest projectsEnableXpnResourceRequestResource) {
        EnableXpnResourceProjectHttpRequest request = EnableXpnResourceProjectHttpRequest.newBuilder().setProject(project).setProjectsEnableXpnResourceRequestResource(projectsEnableXpnResourceRequestResource).build();
        return this.enableXpnResourceProject(request);
    }

    @BetaApi
    public final Operation enableXpnResourceProject(EnableXpnResourceProjectHttpRequest request) {
        return (Operation)this.enableXpnResourceProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<EnableXpnResourceProjectHttpRequest, Operation> enableXpnResourceProjectCallable() {
        return this.stub.enableXpnResourceProjectCallable();
    }

    @BetaApi
    public final Project getProject(ProjectName project) {
        GetProjectHttpRequest request = GetProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.getProject(request);
    }

    @BetaApi
    public final Project getProject(String project) {
        GetProjectHttpRequest request = GetProjectHttpRequest.newBuilder().setProject(project).build();
        return this.getProject(request);
    }

    @BetaApi
    private final Project getProject(GetProjectHttpRequest request) {
        return (Project)this.getProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetProjectHttpRequest, Project> getProjectCallable() {
        return this.stub.getProjectCallable();
    }

    @BetaApi
    public final Project getXpnHostProject(ProjectName project) {
        GetXpnHostProjectHttpRequest request = GetXpnHostProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.getXpnHostProject(request);
    }

    @BetaApi
    public final Project getXpnHostProject(String project) {
        GetXpnHostProjectHttpRequest request = GetXpnHostProjectHttpRequest.newBuilder().setProject(project).build();
        return this.getXpnHostProject(request);
    }

    @BetaApi
    private final Project getXpnHostProject(GetXpnHostProjectHttpRequest request) {
        return (Project)this.getXpnHostProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetXpnHostProjectHttpRequest, Project> getXpnHostProjectCallable() {
        return this.stub.getXpnHostProjectCallable();
    }

    @BetaApi
    public final GetXpnResourcesProjectsPagedResponse getXpnResourcesProjects(ProjectName project) {
        GetXpnResourcesProjectsHttpRequest request = GetXpnResourcesProjectsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.getXpnResourcesProjects(request);
    }

    @BetaApi
    public final GetXpnResourcesProjectsPagedResponse getXpnResourcesProjects(String project) {
        GetXpnResourcesProjectsHttpRequest request = GetXpnResourcesProjectsHttpRequest.newBuilder().setProject(project).build();
        return this.getXpnResourcesProjects(request);
    }

    @BetaApi
    public final GetXpnResourcesProjectsPagedResponse getXpnResourcesProjects(GetXpnResourcesProjectsHttpRequest request) {
        return (GetXpnResourcesProjectsPagedResponse)((Object)this.getXpnResourcesProjectsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<GetXpnResourcesProjectsHttpRequest, GetXpnResourcesProjectsPagedResponse> getXpnResourcesProjectsPagedCallable() {
        return this.stub.getXpnResourcesProjectsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources> getXpnResourcesProjectsCallable() {
        return this.stub.getXpnResourcesProjectsCallable();
    }

    @BetaApi
    public final ListXpnHostsProjectsPagedResponse listXpnHostsProjects(ProjectName project, ProjectsListXpnHostsRequest projectsListXpnHostsRequestResource) {
        ListXpnHostsProjectsHttpRequest request = ListXpnHostsProjectsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setProjectsListXpnHostsRequestResource(projectsListXpnHostsRequestResource).build();
        return this.listXpnHostsProjects(request);
    }

    @BetaApi
    public final ListXpnHostsProjectsPagedResponse listXpnHostsProjects(String project, ProjectsListXpnHostsRequest projectsListXpnHostsRequestResource) {
        ListXpnHostsProjectsHttpRequest request = ListXpnHostsProjectsHttpRequest.newBuilder().setProject(project).setProjectsListXpnHostsRequestResource(projectsListXpnHostsRequestResource).build();
        return this.listXpnHostsProjects(request);
    }

    @BetaApi
    public final ListXpnHostsProjectsPagedResponse listXpnHostsProjects(ListXpnHostsProjectsHttpRequest request) {
        return (ListXpnHostsProjectsPagedResponse)((Object)this.listXpnHostsProjectsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListXpnHostsProjectsHttpRequest, ListXpnHostsProjectsPagedResponse> listXpnHostsProjectsPagedCallable() {
        return this.stub.listXpnHostsProjectsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListXpnHostsProjectsHttpRequest, XpnHostList> listXpnHostsProjectsCallable() {
        return this.stub.listXpnHostsProjectsCallable();
    }

    @BetaApi
    public final Operation moveDiskProject(ProjectName project, DiskMoveRequest diskMoveRequestResource) {
        MoveDiskProjectHttpRequest request = MoveDiskProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setDiskMoveRequestResource(diskMoveRequestResource).build();
        return this.moveDiskProject(request);
    }

    @BetaApi
    public final Operation moveDiskProject(String project, DiskMoveRequest diskMoveRequestResource) {
        MoveDiskProjectHttpRequest request = MoveDiskProjectHttpRequest.newBuilder().setProject(project).setDiskMoveRequestResource(diskMoveRequestResource).build();
        return this.moveDiskProject(request);
    }

    @BetaApi
    public final Operation moveDiskProject(MoveDiskProjectHttpRequest request) {
        return (Operation)this.moveDiskProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<MoveDiskProjectHttpRequest, Operation> moveDiskProjectCallable() {
        return this.stub.moveDiskProjectCallable();
    }

    @BetaApi
    public final Operation moveInstanceProject(ProjectName project, InstanceMoveRequest instanceMoveRequestResource) {
        MoveInstanceProjectHttpRequest request = MoveInstanceProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setInstanceMoveRequestResource(instanceMoveRequestResource).build();
        return this.moveInstanceProject(request);
    }

    @BetaApi
    public final Operation moveInstanceProject(String project, InstanceMoveRequest instanceMoveRequestResource) {
        MoveInstanceProjectHttpRequest request = MoveInstanceProjectHttpRequest.newBuilder().setProject(project).setInstanceMoveRequestResource(instanceMoveRequestResource).build();
        return this.moveInstanceProject(request);
    }

    @BetaApi
    public final Operation moveInstanceProject(MoveInstanceProjectHttpRequest request) {
        return (Operation)this.moveInstanceProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<MoveInstanceProjectHttpRequest, Operation> moveInstanceProjectCallable() {
        return this.stub.moveInstanceProjectCallable();
    }

    @BetaApi
    public final Operation setCommonInstanceMetadataProject(ProjectName project, Metadata metadataResource) {
        SetCommonInstanceMetadataProjectHttpRequest request = SetCommonInstanceMetadataProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setMetadataResource(metadataResource).build();
        return this.setCommonInstanceMetadataProject(request);
    }

    @BetaApi
    public final Operation setCommonInstanceMetadataProject(String project, Metadata metadataResource) {
        SetCommonInstanceMetadataProjectHttpRequest request = SetCommonInstanceMetadataProjectHttpRequest.newBuilder().setProject(project).setMetadataResource(metadataResource).build();
        return this.setCommonInstanceMetadataProject(request);
    }

    @BetaApi
    public final Operation setCommonInstanceMetadataProject(SetCommonInstanceMetadataProjectHttpRequest request) {
        return (Operation)this.setCommonInstanceMetadataProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetCommonInstanceMetadataProjectHttpRequest, Operation> setCommonInstanceMetadataProjectCallable() {
        return this.stub.setCommonInstanceMetadataProjectCallable();
    }

    @BetaApi
    public final Operation setDefaultNetworkTierProject(ProjectName project, ProjectsSetDefaultNetworkTierRequest projectsSetDefaultNetworkTierRequestResource) {
        SetDefaultNetworkTierProjectHttpRequest request = SetDefaultNetworkTierProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setProjectsSetDefaultNetworkTierRequestResource(projectsSetDefaultNetworkTierRequestResource).build();
        return this.setDefaultNetworkTierProject(request);
    }

    @BetaApi
    public final Operation setDefaultNetworkTierProject(String project, ProjectsSetDefaultNetworkTierRequest projectsSetDefaultNetworkTierRequestResource) {
        SetDefaultNetworkTierProjectHttpRequest request = SetDefaultNetworkTierProjectHttpRequest.newBuilder().setProject(project).setProjectsSetDefaultNetworkTierRequestResource(projectsSetDefaultNetworkTierRequestResource).build();
        return this.setDefaultNetworkTierProject(request);
    }

    @BetaApi
    public final Operation setDefaultNetworkTierProject(SetDefaultNetworkTierProjectHttpRequest request) {
        return (Operation)this.setDefaultNetworkTierProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetDefaultNetworkTierProjectHttpRequest, Operation> setDefaultNetworkTierProjectCallable() {
        return this.stub.setDefaultNetworkTierProjectCallable();
    }

    @BetaApi
    public final Operation setUsageExportBucketProject(ProjectName project, UsageExportLocation usageExportLocationResource) {
        SetUsageExportBucketProjectHttpRequest request = SetUsageExportBucketProjectHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setUsageExportLocationResource(usageExportLocationResource).build();
        return this.setUsageExportBucketProject(request);
    }

    @BetaApi
    public final Operation setUsageExportBucketProject(String project, UsageExportLocation usageExportLocationResource) {
        SetUsageExportBucketProjectHttpRequest request = SetUsageExportBucketProjectHttpRequest.newBuilder().setProject(project).setUsageExportLocationResource(usageExportLocationResource).build();
        return this.setUsageExportBucketProject(request);
    }

    @BetaApi
    public final Operation setUsageExportBucketProject(SetUsageExportBucketProjectHttpRequest request) {
        return (Operation)this.setUsageExportBucketProjectCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetUsageExportBucketProjectHttpRequest, Operation> setUsageExportBucketProjectCallable() {
        return this.stub.setUsageExportBucketProjectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListXpnHostsProjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListXpnHostsProjectsHttpRequest, XpnHostList, Project, ListXpnHostsProjectsPage, ListXpnHostsProjectsFixedSizeCollection> {
        private ListXpnHostsProjectsFixedSizeCollection(List<ListXpnHostsProjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListXpnHostsProjectsFixedSizeCollection createEmptyCollection() {
            return new ListXpnHostsProjectsFixedSizeCollection(null, 0);
        }

        protected ListXpnHostsProjectsFixedSizeCollection createCollection(List<ListXpnHostsProjectsPage> pages, int collectionSize) {
            return new ListXpnHostsProjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListXpnHostsProjectsPage
    extends AbstractPage<ListXpnHostsProjectsHttpRequest, XpnHostList, Project, ListXpnHostsProjectsPage> {
        private ListXpnHostsProjectsPage(PageContext<ListXpnHostsProjectsHttpRequest, XpnHostList, Project> context, XpnHostList response) {
            super(context, (Object)response);
        }

        private static ListXpnHostsProjectsPage createEmptyPage() {
            return new ListXpnHostsProjectsPage(null, null);
        }

        protected ListXpnHostsProjectsPage createPage(PageContext<ListXpnHostsProjectsHttpRequest, XpnHostList, Project> context, XpnHostList response) {
            return new ListXpnHostsProjectsPage(context, response);
        }

        public ApiFuture<ListXpnHostsProjectsPage> createPageAsync(PageContext<ListXpnHostsProjectsHttpRequest, XpnHostList, Project> context, ApiFuture<XpnHostList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListXpnHostsProjectsPagedResponse
    extends AbstractPagedListResponse<ListXpnHostsProjectsHttpRequest, XpnHostList, Project, ListXpnHostsProjectsPage, ListXpnHostsProjectsFixedSizeCollection> {
        public static ApiFuture<ListXpnHostsProjectsPagedResponse> createAsync(PageContext<ListXpnHostsProjectsHttpRequest, XpnHostList, Project> context, ApiFuture<XpnHostList> futureResponse) {
            ApiFuture<ListXpnHostsProjectsPage> futurePage = ListXpnHostsProjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListXpnHostsProjectsPage, ListXpnHostsProjectsPagedResponse>(){

                public ListXpnHostsProjectsPagedResponse apply(ListXpnHostsProjectsPage input) {
                    return new ListXpnHostsProjectsPagedResponse(input);
                }
            });
        }

        private ListXpnHostsProjectsPagedResponse(ListXpnHostsProjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListXpnHostsProjectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GetXpnResourcesProjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesProjectsPage, GetXpnResourcesProjectsFixedSizeCollection> {
        private GetXpnResourcesProjectsFixedSizeCollection(List<GetXpnResourcesProjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GetXpnResourcesProjectsFixedSizeCollection createEmptyCollection() {
            return new GetXpnResourcesProjectsFixedSizeCollection(null, 0);
        }

        protected GetXpnResourcesProjectsFixedSizeCollection createCollection(List<GetXpnResourcesProjectsPage> pages, int collectionSize) {
            return new GetXpnResourcesProjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GetXpnResourcesProjectsPage
    extends AbstractPage<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesProjectsPage> {
        private GetXpnResourcesProjectsPage(PageContext<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId> context, ProjectsGetXpnResources response) {
            super(context, (Object)response);
        }

        private static GetXpnResourcesProjectsPage createEmptyPage() {
            return new GetXpnResourcesProjectsPage(null, null);
        }

        protected GetXpnResourcesProjectsPage createPage(PageContext<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId> context, ProjectsGetXpnResources response) {
            return new GetXpnResourcesProjectsPage(context, response);
        }

        public ApiFuture<GetXpnResourcesProjectsPage> createPageAsync(PageContext<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId> context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GetXpnResourcesProjectsPagedResponse
    extends AbstractPagedListResponse<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId, GetXpnResourcesProjectsPage, GetXpnResourcesProjectsFixedSizeCollection> {
        public static ApiFuture<GetXpnResourcesProjectsPagedResponse> createAsync(PageContext<GetXpnResourcesProjectsHttpRequest, ProjectsGetXpnResources, XpnResourceId> context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            ApiFuture<GetXpnResourcesProjectsPage> futurePage = GetXpnResourcesProjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<GetXpnResourcesProjectsPage, GetXpnResourcesProjectsPagedResponse>(){

                public GetXpnResourcesProjectsPagedResponse apply(GetXpnResourcesProjectsPage input) {
                    return new GetXpnResourcesProjectsPagedResponse(input);
                }
            });
        }

        private GetXpnResourcesProjectsPagedResponse(GetXpnResourcesProjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GetXpnResourcesProjectsFixedSizeCollection.createEmptyCollection());
        }
    }
}

