/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Allowed
implements ApiMessage {
    private final String iPProtocol;
    private final List<String> ports;
    private static final Allowed DEFAULT_INSTANCE = new Allowed();

    private Allowed() {
        this.iPProtocol = null;
        this.ports = null;
    }

    private Allowed(String iPProtocol, List<String> ports) {
        this.iPProtocol = iPProtocol;
        this.ports = ports;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("iPProtocol")) {
            return this.iPProtocol;
        }
        if (fieldName.equals("ports")) {
            return this.ports;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getIPProtocol() {
        return this.iPProtocol;
    }

    public List<String> getPortsList() {
        return this.ports;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Allowed prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Allowed getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Allowed{iPProtocol=" + this.iPProtocol + ", ports=" + this.ports + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Allowed) {
            Allowed that = (Allowed)o;
            return Objects.equals(this.iPProtocol, that.getIPProtocol()) && Objects.equals(this.ports, that.getPortsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.iPProtocol, this.ports);
    }

    public static class Builder {
        private String iPProtocol;
        private List<String> ports;

        Builder() {
        }

        public Builder mergeFrom(Allowed other) {
            if (other == Allowed.getDefaultInstance()) {
                return this;
            }
            if (other.getIPProtocol() != null) {
                this.iPProtocol = other.iPProtocol;
            }
            if (other.getPortsList() != null) {
                this.ports = other.ports;
            }
            return this;
        }

        Builder(Allowed source) {
            this.iPProtocol = source.iPProtocol;
            this.ports = source.ports;
        }

        public String getIPProtocol() {
            return this.iPProtocol;
        }

        public Builder setIPProtocol(String iPProtocol) {
            this.iPProtocol = iPProtocol;
            return this;
        }

        public List<String> getPortsList() {
            return this.ports;
        }

        public Builder addAllPorts(List<String> ports) {
            if (this.ports == null) {
                this.ports = new LinkedList<String>();
            }
            this.ports.addAll(ports);
            return this;
        }

        public Builder addPorts(String ports) {
            if (this.ports == null) {
                this.ports = new LinkedList<String>();
            }
            this.ports.add(ports);
            return this;
        }

        public Allowed build() {
            return new Allowed(this.iPProtocol, this.ports);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setIPProtocol(this.iPProtocol);
            newBuilder.addAllPorts(this.ports);
            return newBuilder;
        }
    }
}

