/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteImageHttpRequest;
import com.google.cloud.compute.v1.DeprecateImageHttpRequest;
import com.google.cloud.compute.v1.DeprecationStatus;
import com.google.cloud.compute.v1.GetFromFamilyImageHttpRequest;
import com.google.cloud.compute.v1.GetImageHttpRequest;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.Image;
import com.google.cloud.compute.v1.ImageList;
import com.google.cloud.compute.v1.ImageSettings;
import com.google.cloud.compute.v1.InsertImageHttpRequest;
import com.google.cloud.compute.v1.ListImagesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalImageFamilyName;
import com.google.cloud.compute.v1.ProjectGlobalImageName;
import com.google.cloud.compute.v1.ProjectGlobalImageResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetLabelsImageHttpRequest;
import com.google.cloud.compute.v1.stub.ImageStub;
import com.google.cloud.compute.v1.stub.ImageStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ImageClient
implements BackgroundResource {
    private final ImageSettings settings;
    private final ImageStub stub;

    public static final ImageClient create() throws IOException {
        return ImageClient.create(ImageSettings.newBuilder().build());
    }

    public static final ImageClient create(ImageSettings settings) throws IOException {
        return new ImageClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ImageClient create(ImageStub stub) {
        return new ImageClient(stub);
    }

    protected ImageClient(ImageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ImageStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ImageClient(ImageStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ImageSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ImageStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteImage(ProjectGlobalImageName image) {
        DeleteImageHttpRequest request = DeleteImageHttpRequest.newBuilder().setImage(image == null ? null : image.toString()).build();
        return this.deleteImage(request);
    }

    @BetaApi
    public final Operation deleteImage(String image) {
        DeleteImageHttpRequest request = DeleteImageHttpRequest.newBuilder().setImage(image).build();
        return this.deleteImage(request);
    }

    @BetaApi
    public final Operation deleteImage(DeleteImageHttpRequest request) {
        return (Operation)this.deleteImageCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteImageHttpRequest, Operation> deleteImageCallable() {
        return this.stub.deleteImageCallable();
    }

    @BetaApi
    public final Operation deprecateImage(ProjectGlobalImageName image, DeprecationStatus deprecationStatusResource) {
        DeprecateImageHttpRequest request = DeprecateImageHttpRequest.newBuilder().setImage(image == null ? null : image.toString()).setDeprecationStatusResource(deprecationStatusResource).build();
        return this.deprecateImage(request);
    }

    @BetaApi
    public final Operation deprecateImage(String image, DeprecationStatus deprecationStatusResource) {
        DeprecateImageHttpRequest request = DeprecateImageHttpRequest.newBuilder().setImage(image).setDeprecationStatusResource(deprecationStatusResource).build();
        return this.deprecateImage(request);
    }

    @BetaApi
    public final Operation deprecateImage(DeprecateImageHttpRequest request) {
        return (Operation)this.deprecateImageCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeprecateImageHttpRequest, Operation> deprecateImageCallable() {
        return this.stub.deprecateImageCallable();
    }

    @BetaApi
    public final Image getImage(ProjectGlobalImageName image) {
        GetImageHttpRequest request = GetImageHttpRequest.newBuilder().setImage(image == null ? null : image.toString()).build();
        return this.getImage(request);
    }

    @BetaApi
    public final Image getImage(String image) {
        GetImageHttpRequest request = GetImageHttpRequest.newBuilder().setImage(image).build();
        return this.getImage(request);
    }

    @BetaApi
    public final Image getImage(GetImageHttpRequest request) {
        return (Image)this.getImageCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetImageHttpRequest, Image> getImageCallable() {
        return this.stub.getImageCallable();
    }

    @BetaApi
    public final Image getFromFamilyImage(ProjectGlobalImageFamilyName family) {
        GetFromFamilyImageHttpRequest request = GetFromFamilyImageHttpRequest.newBuilder().setFamily(family == null ? null : family.toString()).build();
        return this.getFromFamilyImage(request);
    }

    @BetaApi
    public final Image getFromFamilyImage(String family) {
        GetFromFamilyImageHttpRequest request = GetFromFamilyImageHttpRequest.newBuilder().setFamily(family).build();
        return this.getFromFamilyImage(request);
    }

    @BetaApi
    public final Image getFromFamilyImage(GetFromFamilyImageHttpRequest request) {
        return (Image)this.getFromFamilyImageCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageCallable() {
        return this.stub.getFromFamilyImageCallable();
    }

    @BetaApi
    public final Operation insertImage(Boolean forceCreate, ProjectName project, Image imageResource) {
        InsertImageHttpRequest request = InsertImageHttpRequest.newBuilder().setForceCreate(forceCreate).setProject(project == null ? null : project.toString()).setImageResource(imageResource).build();
        return this.insertImage(request);
    }

    @BetaApi
    public final Operation insertImage(Boolean forceCreate, String project, Image imageResource) {
        InsertImageHttpRequest request = InsertImageHttpRequest.newBuilder().setForceCreate(forceCreate).setProject(project).setImageResource(imageResource).build();
        return this.insertImage(request);
    }

    @BetaApi
    public final Operation insertImage(InsertImageHttpRequest request) {
        return (Operation)this.insertImageCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertImageHttpRequest, Operation> insertImageCallable() {
        return this.stub.insertImageCallable();
    }

    @BetaApi
    public final ListImagesPagedResponse listImages(ProjectName project) {
        ListImagesHttpRequest request = ListImagesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listImages(request);
    }

    @BetaApi
    public final ListImagesPagedResponse listImages(String project) {
        ListImagesHttpRequest request = ListImagesHttpRequest.newBuilder().setProject(project).build();
        return this.listImages(request);
    }

    @BetaApi
    public final ListImagesPagedResponse listImages(ListImagesHttpRequest request) {
        return (ListImagesPagedResponse)((Object)this.listImagesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListImagesHttpRequest, ListImagesPagedResponse> listImagesPagedCallable() {
        return this.stub.listImagesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListImagesHttpRequest, ImageList> listImagesCallable() {
        return this.stub.listImagesCallable();
    }

    @BetaApi
    public final Operation setLabelsImage(ProjectGlobalImageResourceName resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsImageHttpRequest request = SetLabelsImageHttpRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsImage(request);
    }

    @BetaApi
    public final Operation setLabelsImage(String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsImageHttpRequest request = SetLabelsImageHttpRequest.newBuilder().setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsImage(request);
    }

    @BetaApi
    public final Operation setLabelsImage(SetLabelsImageHttpRequest request) {
        return (Operation)this.setLabelsImageCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetLabelsImageHttpRequest, Operation> setLabelsImageCallable() {
        return this.stub.setLabelsImageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListImagesHttpRequest, ImageList, Image, ListImagesPage, ListImagesFixedSizeCollection> {
        private ListImagesFixedSizeCollection(List<ListImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListImagesFixedSizeCollection createEmptyCollection() {
            return new ListImagesFixedSizeCollection(null, 0);
        }

        protected ListImagesFixedSizeCollection createCollection(List<ListImagesPage> pages, int collectionSize) {
            return new ListImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListImagesPage
    extends AbstractPage<ListImagesHttpRequest, ImageList, Image, ListImagesPage> {
        private ListImagesPage(PageContext<ListImagesHttpRequest, ImageList, Image> context, ImageList response) {
            super(context, (Object)response);
        }

        private static ListImagesPage createEmptyPage() {
            return new ListImagesPage(null, null);
        }

        protected ListImagesPage createPage(PageContext<ListImagesHttpRequest, ImageList, Image> context, ImageList response) {
            return new ListImagesPage(context, response);
        }

        public ApiFuture<ListImagesPage> createPageAsync(PageContext<ListImagesHttpRequest, ImageList, Image> context, ApiFuture<ImageList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListImagesPagedResponse
    extends AbstractPagedListResponse<ListImagesHttpRequest, ImageList, Image, ListImagesPage, ListImagesFixedSizeCollection> {
        public static ApiFuture<ListImagesPagedResponse> createAsync(PageContext<ListImagesHttpRequest, ImageList, Image> context, ApiFuture<ImageList> futureResponse) {
            ApiFuture<ListImagesPage> futurePage = ListImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListImagesPage, ListImagesPagedResponse>(){

                public ListImagesPagedResponse apply(ListImagesPage input) {
                    return new ListImagesPagedResponse(input);
                }
            });
        }

        private ListImagesPagedResponse(ListImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListImagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

