/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionDiskTypeName
implements ResourceName {
    private final String diskType;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/regions/{region}/diskTypes/{diskType}");
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionDiskTypeName(Builder builder) {
        this.diskType = (String)Preconditions.checkNotNull((Object)builder.getDiskType());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionDiskTypeName of(String diskType, String project, String region) {
        return ProjectRegionDiskTypeName.newBuilder().setDiskType(diskType).setProject(project).setRegion(region).build();
    }

    public static String format(String diskType, String project, String region) {
        return ProjectRegionDiskTypeName.of(diskType, project, region).toString();
    }

    public String getDiskType() {
        return this.diskType;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionDiskTypeName projectRegionDiskTypeName = this;
            synchronized (projectRegionDiskTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"diskType", (Object)this.diskType);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionDiskTypeName> newFactory() {
        return new ResourceNameFactory<ProjectRegionDiskTypeName>(){

            public ProjectRegionDiskTypeName parse(String formattedString) {
                return ProjectRegionDiskTypeName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionDiskTypeName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRegionDiskTypeName.parse: formattedString not in valid format");
        return ProjectRegionDiskTypeName.of((String)matchMap.get("diskType"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"diskType", this.diskType, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionDiskTypeName) {
            ProjectRegionDiskTypeName that = (ProjectRegionDiskTypeName)o;
            return Objects.equals(this.diskType, that.getDiskType()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.diskType, this.project, this.region);
    }

    public static class Builder {
        private String diskType;
        private String project;
        private String region;

        public String getDiskType() {
            return this.diskType;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setDiskType(String diskType) {
            this.diskType = diskType;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionDiskTypeName projectRegionDiskTypeName) {
            this.diskType = projectRegionDiskTypeName.diskType;
            this.project = projectRegionDiskTypeName.project;
            this.region = projectRegionDiskTypeName.region;
        }

        public ProjectRegionDiskTypeName build() {
            return new ProjectRegionDiskTypeName(this);
        }
    }
}

