/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BackendBucket;
import com.google.cloud.compute.v1.BackendBucketList;
import com.google.cloud.compute.v1.BackendBucketSettings;
import com.google.cloud.compute.v1.DeleteBackendBucketHttpRequest;
import com.google.cloud.compute.v1.GetBackendBucketHttpRequest;
import com.google.cloud.compute.v1.InsertBackendBucketHttpRequest;
import com.google.cloud.compute.v1.ListBackendBucketsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendBucketHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalBackendBucketName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateBackendBucketHttpRequest;
import com.google.cloud.compute.v1.stub.BackendBucketStub;
import com.google.cloud.compute.v1.stub.BackendBucketStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BackendBucketClient
implements BackgroundResource {
    private final BackendBucketSettings settings;
    private final BackendBucketStub stub;

    public static final BackendBucketClient create() throws IOException {
        return BackendBucketClient.create(BackendBucketSettings.newBuilder().build());
    }

    public static final BackendBucketClient create(BackendBucketSettings settings) throws IOException {
        return new BackendBucketClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BackendBucketClient create(BackendBucketStub stub) {
        return new BackendBucketClient(stub);
    }

    protected BackendBucketClient(BackendBucketSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackendBucketStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BackendBucketClient(BackendBucketStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BackendBucketSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BackendBucketStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteBackendBucket(ProjectGlobalBackendBucketName backendBucket) {
        DeleteBackendBucketHttpRequest request = DeleteBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket == null ? null : backendBucket.toString()).build();
        return this.deleteBackendBucket(request);
    }

    @BetaApi
    public final Operation deleteBackendBucket(String backendBucket) {
        DeleteBackendBucketHttpRequest request = DeleteBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket).build();
        return this.deleteBackendBucket(request);
    }

    @BetaApi
    public final Operation deleteBackendBucket(DeleteBackendBucketHttpRequest request) {
        return (Operation)this.deleteBackendBucketCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteBackendBucketHttpRequest, Operation> deleteBackendBucketCallable() {
        return this.stub.deleteBackendBucketCallable();
    }

    @BetaApi
    public final BackendBucket getBackendBucket(ProjectGlobalBackendBucketName backendBucket) {
        GetBackendBucketHttpRequest request = GetBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket == null ? null : backendBucket.toString()).build();
        return this.getBackendBucket(request);
    }

    @BetaApi
    public final BackendBucket getBackendBucket(String backendBucket) {
        GetBackendBucketHttpRequest request = GetBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket).build();
        return this.getBackendBucket(request);
    }

    @BetaApi
    public final BackendBucket getBackendBucket(GetBackendBucketHttpRequest request) {
        return (BackendBucket)this.getBackendBucketCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetBackendBucketHttpRequest, BackendBucket> getBackendBucketCallable() {
        return this.stub.getBackendBucketCallable();
    }

    @BetaApi
    public final Operation insertBackendBucket(ProjectName project, BackendBucket backendBucketResource) {
        InsertBackendBucketHttpRequest request = InsertBackendBucketHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setBackendBucketResource(backendBucketResource).build();
        return this.insertBackendBucket(request);
    }

    @BetaApi
    public final Operation insertBackendBucket(String project, BackendBucket backendBucketResource) {
        InsertBackendBucketHttpRequest request = InsertBackendBucketHttpRequest.newBuilder().setProject(project).setBackendBucketResource(backendBucketResource).build();
        return this.insertBackendBucket(request);
    }

    @BetaApi
    public final Operation insertBackendBucket(InsertBackendBucketHttpRequest request) {
        return (Operation)this.insertBackendBucketCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertBackendBucketHttpRequest, Operation> insertBackendBucketCallable() {
        return this.stub.insertBackendBucketCallable();
    }

    @BetaApi
    public final ListBackendBucketsPagedResponse listBackendBuckets(ProjectName project) {
        ListBackendBucketsHttpRequest request = ListBackendBucketsHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listBackendBuckets(request);
    }

    @BetaApi
    public final ListBackendBucketsPagedResponse listBackendBuckets(String project) {
        ListBackendBucketsHttpRequest request = ListBackendBucketsHttpRequest.newBuilder().setProject(project).build();
        return this.listBackendBuckets(request);
    }

    @BetaApi
    public final ListBackendBucketsPagedResponse listBackendBuckets(ListBackendBucketsHttpRequest request) {
        return (ListBackendBucketsPagedResponse)((Object)this.listBackendBucketsPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListBackendBucketsHttpRequest, ListBackendBucketsPagedResponse> listBackendBucketsPagedCallable() {
        return this.stub.listBackendBucketsPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListBackendBucketsHttpRequest, BackendBucketList> listBackendBucketsCallable() {
        return this.stub.listBackendBucketsCallable();
    }

    @BetaApi
    public final Operation patchBackendBucket(ProjectGlobalBackendBucketName backendBucket, BackendBucket backendBucketResource, List<String> fieldMask) {
        PatchBackendBucketHttpRequest request = PatchBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket == null ? null : backendBucket.toString()).setBackendBucketResource(backendBucketResource).addAllFieldMask(fieldMask).build();
        return this.patchBackendBucket(request);
    }

    @BetaApi
    public final Operation patchBackendBucket(String backendBucket, BackendBucket backendBucketResource, List<String> fieldMask) {
        PatchBackendBucketHttpRequest request = PatchBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket).setBackendBucketResource(backendBucketResource).addAllFieldMask(fieldMask).build();
        return this.patchBackendBucket(request);
    }

    @BetaApi
    public final Operation patchBackendBucket(PatchBackendBucketHttpRequest request) {
        return (Operation)this.patchBackendBucketCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchBackendBucketHttpRequest, Operation> patchBackendBucketCallable() {
        return this.stub.patchBackendBucketCallable();
    }

    @BetaApi
    public final Operation updateBackendBucket(ProjectGlobalBackendBucketName backendBucket, BackendBucket backendBucketResource, List<String> fieldMask) {
        UpdateBackendBucketHttpRequest request = UpdateBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket == null ? null : backendBucket.toString()).setBackendBucketResource(backendBucketResource).addAllFieldMask(fieldMask).build();
        return this.updateBackendBucket(request);
    }

    @BetaApi
    public final Operation updateBackendBucket(String backendBucket, BackendBucket backendBucketResource, List<String> fieldMask) {
        UpdateBackendBucketHttpRequest request = UpdateBackendBucketHttpRequest.newBuilder().setBackendBucket(backendBucket).setBackendBucketResource(backendBucketResource).addAllFieldMask(fieldMask).build();
        return this.updateBackendBucket(request);
    }

    @BetaApi
    public final Operation updateBackendBucket(UpdateBackendBucketHttpRequest request) {
        return (Operation)this.updateBackendBucketCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateBackendBucketHttpRequest, Operation> updateBackendBucketCallable() {
        return this.stub.updateBackendBucketCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBackendBucketsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket, ListBackendBucketsPage, ListBackendBucketsFixedSizeCollection> {
        private ListBackendBucketsFixedSizeCollection(List<ListBackendBucketsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackendBucketsFixedSizeCollection createEmptyCollection() {
            return new ListBackendBucketsFixedSizeCollection(null, 0);
        }

        protected ListBackendBucketsFixedSizeCollection createCollection(List<ListBackendBucketsPage> pages, int collectionSize) {
            return new ListBackendBucketsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackendBucketsPage
    extends AbstractPage<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket, ListBackendBucketsPage> {
        private ListBackendBucketsPage(PageContext<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket> context, BackendBucketList response) {
            super(context, (Object)response);
        }

        private static ListBackendBucketsPage createEmptyPage() {
            return new ListBackendBucketsPage(null, null);
        }

        protected ListBackendBucketsPage createPage(PageContext<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket> context, BackendBucketList response) {
            return new ListBackendBucketsPage(context, response);
        }

        public ApiFuture<ListBackendBucketsPage> createPageAsync(PageContext<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket> context, ApiFuture<BackendBucketList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackendBucketsPagedResponse
    extends AbstractPagedListResponse<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket, ListBackendBucketsPage, ListBackendBucketsFixedSizeCollection> {
        public static ApiFuture<ListBackendBucketsPagedResponse> createAsync(PageContext<ListBackendBucketsHttpRequest, BackendBucketList, BackendBucket> context, ApiFuture<BackendBucketList> futureResponse) {
            ApiFuture<ListBackendBucketsPage> futurePage = ListBackendBucketsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListBackendBucketsPage, ListBackendBucketsPagedResponse>(){

                public ListBackendBucketsPagedResponse apply(ListBackendBucketsPage input) {
                    return new ListBackendBucketsPagedResponse(input);
                }
            });
        }

        private ListBackendBucketsPagedResponse(ListBackendBucketsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackendBucketsFixedSizeCollection.createEmptyCollection());
        }
    }
}

