/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class Scheduling
implements ApiMessage {
    private final Boolean automaticRestart;
    private final String onHostMaintenance;
    private final Boolean preemptible;
    private static final Scheduling DEFAULT_INSTANCE = new Scheduling();

    private Scheduling() {
        this.automaticRestart = null;
        this.onHostMaintenance = null;
        this.preemptible = null;
    }

    private Scheduling(Boolean automaticRestart, String onHostMaintenance, Boolean preemptible) {
        this.automaticRestart = automaticRestart;
        this.onHostMaintenance = onHostMaintenance;
        this.preemptible = preemptible;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("automaticRestart")) {
            return this.automaticRestart;
        }
        if (fieldName.equals("onHostMaintenance")) {
            return this.onHostMaintenance;
        }
        if (fieldName.equals("preemptible")) {
            return this.preemptible;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAutomaticRestart() {
        return this.automaticRestart;
    }

    public String getOnHostMaintenance() {
        return this.onHostMaintenance;
    }

    public Boolean getPreemptible() {
        return this.preemptible;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Scheduling prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static Scheduling getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "Scheduling{automaticRestart=" + this.automaticRestart + ", onHostMaintenance=" + this.onHostMaintenance + ", preemptible=" + this.preemptible + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Scheduling) {
            Scheduling that = (Scheduling)o;
            return Objects.equals(this.automaticRestart, that.getAutomaticRestart()) && Objects.equals(this.onHostMaintenance, that.getOnHostMaintenance()) && Objects.equals(this.preemptible, that.getPreemptible());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.automaticRestart, this.onHostMaintenance, this.preemptible);
    }

    public static class Builder {
        private Boolean automaticRestart;
        private String onHostMaintenance;
        private Boolean preemptible;

        Builder() {
        }

        public Builder mergeFrom(Scheduling other) {
            if (other == Scheduling.getDefaultInstance()) {
                return this;
            }
            if (other.getAutomaticRestart() != null) {
                this.automaticRestart = other.automaticRestart;
            }
            if (other.getOnHostMaintenance() != null) {
                this.onHostMaintenance = other.onHostMaintenance;
            }
            if (other.getPreemptible() != null) {
                this.preemptible = other.preemptible;
            }
            return this;
        }

        Builder(Scheduling source) {
            this.automaticRestart = source.automaticRestart;
            this.onHostMaintenance = source.onHostMaintenance;
            this.preemptible = source.preemptible;
        }

        public Boolean getAutomaticRestart() {
            return this.automaticRestart;
        }

        public Builder setAutomaticRestart(Boolean automaticRestart) {
            this.automaticRestart = automaticRestart;
            return this;
        }

        public String getOnHostMaintenance() {
            return this.onHostMaintenance;
        }

        public Builder setOnHostMaintenance(String onHostMaintenance) {
            this.onHostMaintenance = onHostMaintenance;
            return this;
        }

        public Boolean getPreemptible() {
            return this.preemptible;
        }

        public Builder setPreemptible(Boolean preemptible) {
            this.preemptible = preemptible;
            return this;
        }

        public Scheduling build() {
            return new Scheduling(this.automaticRestart, this.onHostMaintenance, this.preemptible);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutomaticRestart(this.automaticRestart);
            newBuilder.setOnHostMaintenance(this.onHostMaintenance);
            newBuilder.setPreemptible(this.preemptible);
            return newBuilder;
        }
    }
}

