/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagersSetTargetPoolsRequest
implements ApiMessage {
    private final String fingerprint;
    private final List<String> targetPools;
    private static final InstanceGroupManagersSetTargetPoolsRequest DEFAULT_INSTANCE = new InstanceGroupManagersSetTargetPoolsRequest();

    private InstanceGroupManagersSetTargetPoolsRequest() {
        this.fingerprint = null;
        this.targetPools = null;
    }

    private InstanceGroupManagersSetTargetPoolsRequest(String fingerprint, List<String> targetPools) {
        this.fingerprint = fingerprint;
        this.targetPools = targetPools;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("fingerprint")) {
            return this.fingerprint;
        }
        if (fieldName.equals("targetPools")) {
            return this.targetPools;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public List<String> getTargetPoolsList() {
        return this.targetPools;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagersSetTargetPoolsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagersSetTargetPoolsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagersSetTargetPoolsRequest{fingerprint=" + this.fingerprint + ", targetPools=" + this.targetPools + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagersSetTargetPoolsRequest) {
            InstanceGroupManagersSetTargetPoolsRequest that = (InstanceGroupManagersSetTargetPoolsRequest)o;
            return Objects.equals(this.fingerprint, that.getFingerprint()) && Objects.equals(this.targetPools, that.getTargetPoolsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fingerprint, this.targetPools);
    }

    public static class Builder {
        private String fingerprint;
        private List<String> targetPools;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagersSetTargetPoolsRequest other) {
            if (other == InstanceGroupManagersSetTargetPoolsRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getFingerprint() != null) {
                this.fingerprint = other.fingerprint;
            }
            if (other.getTargetPoolsList() != null) {
                this.targetPools = other.targetPools;
            }
            return this;
        }

        Builder(InstanceGroupManagersSetTargetPoolsRequest source) {
            this.fingerprint = source.fingerprint;
            this.targetPools = source.targetPools;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public List<String> getTargetPoolsList() {
            return this.targetPools;
        }

        public Builder addAllTargetPools(List<String> targetPools) {
            if (this.targetPools == null) {
                this.targetPools = new LinkedList<String>();
            }
            this.targetPools.addAll(targetPools);
            return this;
        }

        public Builder addTargetPools(String targetPools) {
            if (this.targetPools == null) {
                this.targetPools = new LinkedList<String>();
            }
            this.targetPools.add(targetPools);
            return this;
        }

        public InstanceGroupManagersSetTargetPoolsRequest build() {
            return new InstanceGroupManagersSetTargetPoolsRequest(this.fingerprint, this.targetPools);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFingerprint(this.fingerprint);
            newBuilder.addAllTargetPools(this.targetPools);
            return newBuilder;
        }
    }
}

