/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AcceleratorConfig
implements ApiMessage {
    private final Integer acceleratorCount;
    private final String acceleratorType;
    private static final AcceleratorConfig DEFAULT_INSTANCE = new AcceleratorConfig();

    private AcceleratorConfig() {
        this.acceleratorCount = null;
        this.acceleratorType = null;
    }

    private AcceleratorConfig(Integer acceleratorCount, String acceleratorType) {
        this.acceleratorCount = acceleratorCount;
        this.acceleratorType = acceleratorType;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("acceleratorCount")) {
            return this.acceleratorCount;
        }
        if (fieldName.equals("acceleratorType")) {
            return this.acceleratorType;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getAcceleratorCount() {
        return this.acceleratorCount;
    }

    public String getAcceleratorType() {
        return this.acceleratorType;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AcceleratorConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AcceleratorConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AcceleratorConfig{acceleratorCount=" + this.acceleratorCount + ", acceleratorType=" + this.acceleratorType + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AcceleratorConfig) {
            AcceleratorConfig that = (AcceleratorConfig)o;
            return Objects.equals(this.acceleratorCount, that.getAcceleratorCount()) && Objects.equals(this.acceleratorType, that.getAcceleratorType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.acceleratorCount, this.acceleratorType);
    }

    public static class Builder {
        private Integer acceleratorCount;
        private String acceleratorType;

        Builder() {
        }

        public Builder mergeFrom(AcceleratorConfig other) {
            if (other == AcceleratorConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getAcceleratorCount() != null) {
                this.acceleratorCount = other.acceleratorCount;
            }
            if (other.getAcceleratorType() != null) {
                this.acceleratorType = other.acceleratorType;
            }
            return this;
        }

        Builder(AcceleratorConfig source) {
            this.acceleratorCount = source.acceleratorCount;
            this.acceleratorType = source.acceleratorType;
        }

        public Integer getAcceleratorCount() {
            return this.acceleratorCount;
        }

        public Builder setAcceleratorCount(Integer acceleratorCount) {
            this.acceleratorCount = acceleratorCount;
            return this;
        }

        public String getAcceleratorType() {
            return this.acceleratorType;
        }

        public Builder setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        public AcceleratorConfig build() {
            return new AcceleratorConfig(this.acceleratorCount, this.acceleratorType);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAcceleratorCount(this.acceleratorCount);
            newBuilder.setAcceleratorType(this.acceleratorType);
            return newBuilder;
        }
    }
}

