/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Autoscaler;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PatchAutoscalerHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String autoscaler;
    private final Autoscaler autoscalerResource;
    private final String callback;
    private final List<String> fieldMask;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String requestId;
    private final String userIp;
    private final String zone;
    private static final PatchAutoscalerHttpRequest DEFAULT_INSTANCE = new PatchAutoscalerHttpRequest();

    private PatchAutoscalerHttpRequest() {
        this.access_token = null;
        this.autoscaler = null;
        this.autoscalerResource = null;
        this.callback = null;
        this.fieldMask = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.requestId = null;
        this.userIp = null;
        this.zone = null;
    }

    private PatchAutoscalerHttpRequest(String access_token, String autoscaler, Autoscaler autoscalerResource, String callback, List<String> fieldMask, String fields, String key, String prettyPrint, String quotaUser, String requestId, String userIp, String zone) {
        this.access_token = access_token;
        this.autoscaler = autoscaler;
        this.autoscalerResource = autoscalerResource;
        this.callback = callback;
        this.fieldMask = fieldMask;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.requestId = requestId;
        this.userIp = userIp;
        this.zone = zone;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("autoscaler")) {
            return this.autoscaler;
        }
        if (fieldName.equals("autoscalerResource")) {
            return this.autoscalerResource;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("fieldMask")) {
            return this.fieldMask;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("requestId")) {
            return this.requestId;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        if (fieldName.equals("zone")) {
            return this.zone;
        }
        return null;
    }

    @Nullable
    public Autoscaler getApiMessageRequestBody() {
        return this.autoscalerResource;
    }

    @Nullable
    public List<String> getFieldMask() {
        return this.fieldMask;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getAutoscaler() {
        return this.autoscaler;
    }

    public Autoscaler getAutoscalerResource() {
        return this.autoscalerResource;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PatchAutoscalerHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PatchAutoscalerHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PatchAutoscalerHttpRequest{access_token=" + this.access_token + ", autoscaler=" + this.autoscaler + ", autoscalerResource=" + this.autoscalerResource + ", callback=" + this.callback + ", fieldMask=" + this.fieldMask + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", requestId=" + this.requestId + ", userIp=" + this.userIp + ", zone=" + this.zone + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PatchAutoscalerHttpRequest) {
            PatchAutoscalerHttpRequest that = (PatchAutoscalerHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.autoscaler, that.getAutoscaler()) && Objects.equals(this.autoscalerResource, that.getAutoscalerResource()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fieldMask, that.getFieldMask()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.requestId, that.getRequestId()) && Objects.equals(this.userIp, that.getUserIp()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.autoscaler, this.autoscalerResource, this.callback, this.fieldMask, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.userIp, this.zone);
    }

    public static class Builder {
        private String access_token;
        private String autoscaler;
        private Autoscaler autoscalerResource;
        private String callback;
        private List<String> fieldMask;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String requestId;
        private String userIp;
        private String zone;

        Builder() {
        }

        public Builder mergeFrom(PatchAutoscalerHttpRequest other) {
            if (other == PatchAutoscalerHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getAutoscaler() != null) {
                this.autoscaler = other.autoscaler;
            }
            if (other.getAutoscalerResource() != null) {
                this.autoscalerResource = other.autoscalerResource;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFieldMask() != null) {
                this.fieldMask = other.fieldMask;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getRequestId() != null) {
                this.requestId = other.requestId;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            if (other.getZone() != null) {
                this.zone = other.zone;
            }
            return this;
        }

        Builder(PatchAutoscalerHttpRequest source) {
            this.access_token = source.access_token;
            this.autoscaler = source.autoscaler;
            this.autoscalerResource = source.autoscalerResource;
            this.callback = source.callback;
            this.fieldMask = source.fieldMask;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.requestId = source.requestId;
            this.userIp = source.userIp;
            this.zone = source.zone;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getAutoscaler() {
            return this.autoscaler;
        }

        public Builder setAutoscaler(String autoscaler) {
            this.autoscaler = autoscaler;
            return this;
        }

        public Autoscaler getAutoscalerResource() {
            return this.autoscalerResource;
        }

        public Builder setAutoscalerResource(Autoscaler autoscalerResource) {
            this.autoscalerResource = autoscalerResource;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public List<String> getFieldMask() {
            return this.fieldMask;
        }

        public Builder setFieldMask(List<String> fieldMask) {
            this.fieldMask = fieldMask;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Builder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public PatchAutoscalerHttpRequest build() {
            String missing = "";
            if (this.zone == null) {
                missing = missing + " zone";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new PatchAutoscalerHttpRequest(this.access_token, this.autoscaler, this.autoscalerResource, this.callback, this.fieldMask, this.fields, this.key, this.prettyPrint, this.quotaUser, this.requestId, this.userIp, this.zone);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setAutoscaler(this.autoscaler);
            newBuilder.setAutoscalerResource(this.autoscalerResource);
            newBuilder.setCallback(this.callback);
            newBuilder.setFieldMask(this.fieldMask);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setRequestId(this.requestId);
            newBuilder.setUserIp(this.userIp);
            newBuilder.setZone(this.zone);
            return newBuilder;
        }
    }
}

