/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InterconnectLocationRegionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InterconnectLocation
implements ApiMessage {
    private final String address;
    private final String availabilityZone;
    private final String city;
    private final String continent;
    private final String creationTimestamp;
    private final String description;
    private final String facilityProvider;
    private final String facilityProviderFacilityId;
    private final String id;
    private final String kind;
    private final String name;
    private final String peeringdbFacilityId;
    private final List<InterconnectLocationRegionInfo> regionInfos;
    private final String selfLink;
    private static final InterconnectLocation DEFAULT_INSTANCE = new InterconnectLocation();

    private InterconnectLocation() {
        this.address = null;
        this.availabilityZone = null;
        this.city = null;
        this.continent = null;
        this.creationTimestamp = null;
        this.description = null;
        this.facilityProvider = null;
        this.facilityProviderFacilityId = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.peeringdbFacilityId = null;
        this.regionInfos = null;
        this.selfLink = null;
    }

    private InterconnectLocation(String address, String availabilityZone, String city, String continent, String creationTimestamp, String description, String facilityProvider, String facilityProviderFacilityId, String id, String kind, String name, String peeringdbFacilityId, List<InterconnectLocationRegionInfo> regionInfos, String selfLink) {
        this.address = address;
        this.availabilityZone = availabilityZone;
        this.city = city;
        this.continent = continent;
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.facilityProvider = facilityProvider;
        this.facilityProviderFacilityId = facilityProviderFacilityId;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.peeringdbFacilityId = peeringdbFacilityId;
        this.regionInfos = regionInfos;
        this.selfLink = selfLink;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("address")) {
            return this.address;
        }
        if (fieldName.equals("availabilityZone")) {
            return this.availabilityZone;
        }
        if (fieldName.equals("city")) {
            return this.city;
        }
        if (fieldName.equals("continent")) {
            return this.continent;
        }
        if (fieldName.equals("creationTimestamp")) {
            return this.creationTimestamp;
        }
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("facilityProvider")) {
            return this.facilityProvider;
        }
        if (fieldName.equals("facilityProviderFacilityId")) {
            return this.facilityProviderFacilityId;
        }
        if (fieldName.equals("id")) {
            return this.id;
        }
        if (fieldName.equals("kind")) {
            return this.kind;
        }
        if (fieldName.equals("name")) {
            return this.name;
        }
        if (fieldName.equals("peeringdbFacilityId")) {
            return this.peeringdbFacilityId;
        }
        if (fieldName.equals("regionInfos")) {
            return this.regionInfos;
        }
        if (fieldName.equals("selfLink")) {
            return this.selfLink;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getCity() {
        return this.city;
    }

    public String getContinent() {
        return this.continent;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFacilityProvider() {
        return this.facilityProvider;
    }

    public String getFacilityProviderFacilityId() {
        return this.facilityProviderFacilityId;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getPeeringdbFacilityId() {
        return this.peeringdbFacilityId;
    }

    public List<InterconnectLocationRegionInfo> getRegionInfosList() {
        return this.regionInfos;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InterconnectLocation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InterconnectLocation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InterconnectLocation{address=" + this.address + ", availabilityZone=" + this.availabilityZone + ", city=" + this.city + ", continent=" + this.continent + ", creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", facilityProvider=" + this.facilityProvider + ", facilityProviderFacilityId=" + this.facilityProviderFacilityId + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", peeringdbFacilityId=" + this.peeringdbFacilityId + ", regionInfos=" + this.regionInfos + ", selfLink=" + this.selfLink + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterconnectLocation) {
            InterconnectLocation that = (InterconnectLocation)o;
            return Objects.equals(this.address, that.getAddress()) && Objects.equals(this.availabilityZone, that.getAvailabilityZone()) && Objects.equals(this.city, that.getCity()) && Objects.equals(this.continent, that.getContinent()) && Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.facilityProvider, that.getFacilityProvider()) && Objects.equals(this.facilityProviderFacilityId, that.getFacilityProviderFacilityId()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.peeringdbFacilityId, that.getPeeringdbFacilityId()) && Objects.equals(this.regionInfos, that.getRegionInfosList()) && Objects.equals(this.selfLink, that.getSelfLink());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.availabilityZone, this.city, this.continent, this.creationTimestamp, this.description, this.facilityProvider, this.facilityProviderFacilityId, this.id, this.kind, this.name, this.peeringdbFacilityId, this.regionInfos, this.selfLink);
    }

    public static class Builder {
        private String address;
        private String availabilityZone;
        private String city;
        private String continent;
        private String creationTimestamp;
        private String description;
        private String facilityProvider;
        private String facilityProviderFacilityId;
        private String id;
        private String kind;
        private String name;
        private String peeringdbFacilityId;
        private List<InterconnectLocationRegionInfo> regionInfos;
        private String selfLink;

        Builder() {
        }

        public Builder mergeFrom(InterconnectLocation other) {
            if (other == InterconnectLocation.getDefaultInstance()) {
                return this;
            }
            if (other.getAddress() != null) {
                this.address = other.address;
            }
            if (other.getAvailabilityZone() != null) {
                this.availabilityZone = other.availabilityZone;
            }
            if (other.getCity() != null) {
                this.city = other.city;
            }
            if (other.getContinent() != null) {
                this.continent = other.continent;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getFacilityProvider() != null) {
                this.facilityProvider = other.facilityProvider;
            }
            if (other.getFacilityProviderFacilityId() != null) {
                this.facilityProviderFacilityId = other.facilityProviderFacilityId;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getPeeringdbFacilityId() != null) {
                this.peeringdbFacilityId = other.peeringdbFacilityId;
            }
            if (other.getRegionInfosList() != null) {
                this.regionInfos = other.regionInfos;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            return this;
        }

        Builder(InterconnectLocation source) {
            this.address = source.address;
            this.availabilityZone = source.availabilityZone;
            this.city = source.city;
            this.continent = source.continent;
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.facilityProvider = source.facilityProvider;
            this.facilityProviderFacilityId = source.facilityProviderFacilityId;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.peeringdbFacilityId = source.peeringdbFacilityId;
            this.regionInfos = source.regionInfos;
            this.selfLink = source.selfLink;
        }

        public String getAddress() {
            return this.address;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public Builder setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public String getCity() {
            return this.city;
        }

        public Builder setCity(String city) {
            this.city = city;
            return this;
        }

        public String getContinent() {
            return this.continent;
        }

        public Builder setContinent(String continent) {
            this.continent = continent;
            return this;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getFacilityProvider() {
            return this.facilityProvider;
        }

        public Builder setFacilityProvider(String facilityProvider) {
            this.facilityProvider = facilityProvider;
            return this;
        }

        public String getFacilityProviderFacilityId() {
            return this.facilityProviderFacilityId;
        }

        public Builder setFacilityProviderFacilityId(String facilityProviderFacilityId) {
            this.facilityProviderFacilityId = facilityProviderFacilityId;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getPeeringdbFacilityId() {
            return this.peeringdbFacilityId;
        }

        public Builder setPeeringdbFacilityId(String peeringdbFacilityId) {
            this.peeringdbFacilityId = peeringdbFacilityId;
            return this;
        }

        public List<InterconnectLocationRegionInfo> getRegionInfosList() {
            return this.regionInfos;
        }

        public Builder addAllRegionInfos(List<InterconnectLocationRegionInfo> regionInfos) {
            if (this.regionInfos == null) {
                this.regionInfos = new ArrayList<InterconnectLocationRegionInfo>(regionInfos.size());
            }
            this.regionInfos.addAll(regionInfos);
            return this;
        }

        public Builder addRegionInfos(InterconnectLocationRegionInfo regionInfos) {
            this.regionInfos.add(regionInfos);
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public InterconnectLocation build() {
            return new InterconnectLocation(this.address, this.availabilityZone, this.city, this.continent, this.creationTimestamp, this.description, this.facilityProvider, this.facilityProviderFacilityId, this.id, this.kind, this.name, this.peeringdbFacilityId, this.regionInfos, this.selfLink);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAddress(this.address);
            newBuilder.setAvailabilityZone(this.availabilityZone);
            newBuilder.setCity(this.city);
            newBuilder.setContinent(this.continent);
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setFacilityProvider(this.facilityProvider);
            newBuilder.setFacilityProviderFacilityId(this.facilityProviderFacilityId);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setPeeringdbFacilityId(this.peeringdbFacilityId);
            newBuilder.addAllRegionInfos(this.regionInfos);
            newBuilder.setSelfLink(this.selfLink);
            return newBuilder;
        }
    }
}

