/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.GetHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.HttpsHealthCheck2;
import com.google.cloud.compute.v1.HttpsHealthCheckList;
import com.google.cloud.compute.v1.HttpsHealthCheckSettings;
import com.google.cloud.compute.v1.InsertHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ListHttpsHealthChecksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalHttpsHealthCheckName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateHttpsHealthCheckHttpRequest;
import com.google.cloud.compute.v1.stub.HttpsHealthCheckStub;
import com.google.cloud.compute.v1.stub.HttpsHealthCheckStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpsHealthCheckClient
implements BackgroundResource {
    private final HttpsHealthCheckSettings settings;
    private final HttpsHealthCheckStub stub;

    public static final HttpsHealthCheckClient create() throws IOException {
        return HttpsHealthCheckClient.create(HttpsHealthCheckSettings.newBuilder().build());
    }

    public static final HttpsHealthCheckClient create(HttpsHealthCheckSettings settings) throws IOException {
        return new HttpsHealthCheckClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final HttpsHealthCheckClient create(HttpsHealthCheckStub stub) {
        return new HttpsHealthCheckClient(stub);
    }

    protected HttpsHealthCheckClient(HttpsHealthCheckSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HttpsHealthCheckStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected HttpsHealthCheckClient(HttpsHealthCheckStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HttpsHealthCheckSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HttpsHealthCheckStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteHttpsHealthCheck(ProjectGlobalHttpsHealthCheckName httpsHealthCheck) {
        DeleteHttpsHealthCheckHttpRequest request = DeleteHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck == null ? null : httpsHealthCheck.toString()).build();
        return this.deleteHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteHttpsHealthCheck(String httpsHealthCheck) {
        DeleteHttpsHealthCheckHttpRequest request = DeleteHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck).build();
        return this.deleteHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation deleteHttpsHealthCheck(DeleteHttpsHealthCheckHttpRequest request) {
        return (Operation)this.deleteHttpsHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteHttpsHealthCheckHttpRequest, Operation> deleteHttpsHealthCheckCallable() {
        return this.stub.deleteHttpsHealthCheckCallable();
    }

    @BetaApi
    public final HttpsHealthCheck2 getHttpsHealthCheck(ProjectGlobalHttpsHealthCheckName httpsHealthCheck) {
        GetHttpsHealthCheckHttpRequest request = GetHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck == null ? null : httpsHealthCheck.toString()).build();
        return this.getHttpsHealthCheck(request);
    }

    @BetaApi
    public final HttpsHealthCheck2 getHttpsHealthCheck(String httpsHealthCheck) {
        GetHttpsHealthCheckHttpRequest request = GetHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck).build();
        return this.getHttpsHealthCheck(request);
    }

    @BetaApi
    public final HttpsHealthCheck2 getHttpsHealthCheck(GetHttpsHealthCheckHttpRequest request) {
        return (HttpsHealthCheck2)this.getHttpsHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetHttpsHealthCheckHttpRequest, HttpsHealthCheck2> getHttpsHealthCheckCallable() {
        return this.stub.getHttpsHealthCheckCallable();
    }

    @BetaApi
    public final Operation insertHttpsHealthCheck(ProjectName project, HttpsHealthCheck2 httpsHealthCheckResource) {
        InsertHttpsHealthCheckHttpRequest request = InsertHttpsHealthCheckHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setHttpsHealthCheckResource(httpsHealthCheckResource).build();
        return this.insertHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation insertHttpsHealthCheck(String project, HttpsHealthCheck2 httpsHealthCheckResource) {
        InsertHttpsHealthCheckHttpRequest request = InsertHttpsHealthCheckHttpRequest.newBuilder().setProject(project).setHttpsHealthCheckResource(httpsHealthCheckResource).build();
        return this.insertHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation insertHttpsHealthCheck(InsertHttpsHealthCheckHttpRequest request) {
        return (Operation)this.insertHttpsHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertHttpsHealthCheckHttpRequest, Operation> insertHttpsHealthCheckCallable() {
        return this.stub.insertHttpsHealthCheckCallable();
    }

    @BetaApi
    public final ListHttpsHealthChecksPagedResponse listHttpsHealthChecks(ProjectName project) {
        ListHttpsHealthChecksHttpRequest request = ListHttpsHealthChecksHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listHttpsHealthChecks(request);
    }

    @BetaApi
    public final ListHttpsHealthChecksPagedResponse listHttpsHealthChecks(String project) {
        ListHttpsHealthChecksHttpRequest request = ListHttpsHealthChecksHttpRequest.newBuilder().setProject(project).build();
        return this.listHttpsHealthChecks(request);
    }

    @BetaApi
    public final ListHttpsHealthChecksPagedResponse listHttpsHealthChecks(ListHttpsHealthChecksHttpRequest request) {
        return (ListHttpsHealthChecksPagedResponse)((Object)this.listHttpsHealthChecksPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListHttpsHealthChecksHttpRequest, ListHttpsHealthChecksPagedResponse> listHttpsHealthChecksPagedCallable() {
        return this.stub.listHttpsHealthChecksPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList> listHttpsHealthChecksCallable() {
        return this.stub.listHttpsHealthChecksCallable();
    }

    @BetaApi
    public final Operation patchHttpsHealthCheck(ProjectGlobalHttpsHealthCheckName httpsHealthCheck, HttpsHealthCheck2 httpsHealthCheckResource) {
        PatchHttpsHealthCheckHttpRequest request = PatchHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck == null ? null : httpsHealthCheck.toString()).setHttpsHealthCheckResource(httpsHealthCheckResource).build();
        return this.patchHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation patchHttpsHealthCheck(String httpsHealthCheck, HttpsHealthCheck2 httpsHealthCheckResource) {
        PatchHttpsHealthCheckHttpRequest request = PatchHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck).setHttpsHealthCheckResource(httpsHealthCheckResource).build();
        return this.patchHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation patchHttpsHealthCheck(PatchHttpsHealthCheckHttpRequest request) {
        return (Operation)this.patchHttpsHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchHttpsHealthCheckHttpRequest, Operation> patchHttpsHealthCheckCallable() {
        return this.stub.patchHttpsHealthCheckCallable();
    }

    @BetaApi
    public final Operation updateHttpsHealthCheck(ProjectGlobalHttpsHealthCheckName httpsHealthCheck, HttpsHealthCheck2 httpsHealthCheckResource) {
        UpdateHttpsHealthCheckHttpRequest request = UpdateHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck == null ? null : httpsHealthCheck.toString()).setHttpsHealthCheckResource(httpsHealthCheckResource).build();
        return this.updateHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation updateHttpsHealthCheck(String httpsHealthCheck, HttpsHealthCheck2 httpsHealthCheckResource) {
        UpdateHttpsHealthCheckHttpRequest request = UpdateHttpsHealthCheckHttpRequest.newBuilder().setHttpsHealthCheck(httpsHealthCheck).setHttpsHealthCheckResource(httpsHealthCheckResource).build();
        return this.updateHttpsHealthCheck(request);
    }

    @BetaApi
    public final Operation updateHttpsHealthCheck(UpdateHttpsHealthCheckHttpRequest request) {
        return (Operation)this.updateHttpsHealthCheckCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<UpdateHttpsHealthCheckHttpRequest, Operation> updateHttpsHealthCheckCallable() {
        return this.stub.updateHttpsHealthCheckCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListHttpsHealthChecksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2, ListHttpsHealthChecksPage, ListHttpsHealthChecksFixedSizeCollection> {
        private ListHttpsHealthChecksFixedSizeCollection(List<ListHttpsHealthChecksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHttpsHealthChecksFixedSizeCollection createEmptyCollection() {
            return new ListHttpsHealthChecksFixedSizeCollection(null, 0);
        }

        protected ListHttpsHealthChecksFixedSizeCollection createCollection(List<ListHttpsHealthChecksPage> pages, int collectionSize) {
            return new ListHttpsHealthChecksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHttpsHealthChecksPage
    extends AbstractPage<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2, ListHttpsHealthChecksPage> {
        private ListHttpsHealthChecksPage(PageContext<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2> context, HttpsHealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListHttpsHealthChecksPage createEmptyPage() {
            return new ListHttpsHealthChecksPage(null, null);
        }

        protected ListHttpsHealthChecksPage createPage(PageContext<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2> context, HttpsHealthCheckList response) {
            return new ListHttpsHealthChecksPage(context, response);
        }

        public ApiFuture<ListHttpsHealthChecksPage> createPageAsync(PageContext<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2> context, ApiFuture<HttpsHealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHttpsHealthChecksPagedResponse
    extends AbstractPagedListResponse<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2, ListHttpsHealthChecksPage, ListHttpsHealthChecksFixedSizeCollection> {
        public static ApiFuture<ListHttpsHealthChecksPagedResponse> createAsync(PageContext<ListHttpsHealthChecksHttpRequest, HttpsHealthCheckList, HttpsHealthCheck2> context, ApiFuture<HttpsHealthCheckList> futureResponse) {
            ApiFuture<ListHttpsHealthChecksPage> futurePage = ListHttpsHealthChecksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListHttpsHealthChecksPage, ListHttpsHealthChecksPagedResponse>(){

                public ListHttpsHealthChecksPagedResponse apply(ListHttpsHealthChecksPage input) {
                    return new ListHttpsHealthChecksPagedResponse(input);
                }
            });
        }

        private ListHttpsHealthChecksPagedResponse(ListHttpsHealthChecksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHttpsHealthChecksFixedSizeCollection.createEmptyCollection());
        }
    }
}

