/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class GetSnapshotHttpRequest
implements ApiMessage {
    private final String access_token;
    private final String callback;
    private final String fields;
    private final String key;
    private final String prettyPrint;
    private final String quotaUser;
    private final String snapshot;
    private final String userIp;
    private static final GetSnapshotHttpRequest DEFAULT_INSTANCE = new GetSnapshotHttpRequest();

    private GetSnapshotHttpRequest() {
        this.access_token = null;
        this.callback = null;
        this.fields = null;
        this.key = null;
        this.prettyPrint = null;
        this.quotaUser = null;
        this.snapshot = null;
        this.userIp = null;
    }

    private GetSnapshotHttpRequest(String access_token, String callback, String fields, String key, String prettyPrint, String quotaUser, String snapshot, String userIp) {
        this.access_token = access_token;
        this.callback = callback;
        this.fields = fields;
        this.key = key;
        this.prettyPrint = prettyPrint;
        this.quotaUser = quotaUser;
        this.snapshot = snapshot;
        this.userIp = userIp;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("access_token")) {
            return this.access_token;
        }
        if (fieldName.equals("callback")) {
            return this.callback;
        }
        if (fieldName.equals("fields")) {
            return this.fields;
        }
        if (fieldName.equals("key")) {
            return this.key;
        }
        if (fieldName.equals("prettyPrint")) {
            return this.prettyPrint;
        }
        if (fieldName.equals("quotaUser")) {
            return this.quotaUser;
        }
        if (fieldName.equals("snapshot")) {
            return this.snapshot;
        }
        if (fieldName.equals("userIp")) {
            return this.userIp;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getFields() {
        return this.fields;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GetSnapshotHttpRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static GetSnapshotHttpRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "GetSnapshotHttpRequest{access_token=" + this.access_token + ", callback=" + this.callback + ", fields=" + this.fields + ", key=" + this.key + ", prettyPrint=" + this.prettyPrint + ", quotaUser=" + this.quotaUser + ", snapshot=" + this.snapshot + ", userIp=" + this.userIp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GetSnapshotHttpRequest) {
            GetSnapshotHttpRequest that = (GetSnapshotHttpRequest)o;
            return Objects.equals(this.access_token, that.getAccessToken()) && Objects.equals(this.callback, that.getCallback()) && Objects.equals(this.fields, that.getFields()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.prettyPrint, that.getPrettyPrint()) && Objects.equals(this.quotaUser, that.getQuotaUser()) && Objects.equals(this.snapshot, that.getSnapshot()) && Objects.equals(this.userIp, that.getUserIp());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.snapshot, this.userIp);
    }

    public static class Builder {
        private String access_token;
        private String callback;
        private String fields;
        private String key;
        private String prettyPrint;
        private String quotaUser;
        private String snapshot;
        private String userIp;

        Builder() {
        }

        public Builder mergeFrom(GetSnapshotHttpRequest other) {
            if (other == GetSnapshotHttpRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getAccessToken() != null) {
                this.access_token = other.access_token;
            }
            if (other.getCallback() != null) {
                this.callback = other.callback;
            }
            if (other.getFields() != null) {
                this.fields = other.fields;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getPrettyPrint() != null) {
                this.prettyPrint = other.prettyPrint;
            }
            if (other.getQuotaUser() != null) {
                this.quotaUser = other.quotaUser;
            }
            if (other.getSnapshot() != null) {
                this.snapshot = other.snapshot;
            }
            if (other.getUserIp() != null) {
                this.userIp = other.userIp;
            }
            return this;
        }

        Builder(GetSnapshotHttpRequest source) {
            this.access_token = source.access_token;
            this.callback = source.callback;
            this.fields = source.fields;
            this.key = source.key;
            this.prettyPrint = source.prettyPrint;
            this.quotaUser = source.quotaUser;
            this.snapshot = source.snapshot;
            this.userIp = source.userIp;
        }

        public String getAccessToken() {
            return this.access_token;
        }

        public Builder setAccessToken(String access_token) {
            this.access_token = access_token;
            return this;
        }

        public String getCallback() {
            return this.callback;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public String getFields() {
            return this.fields;
        }

        public Builder setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getPrettyPrint() {
            return this.prettyPrint;
        }

        public Builder setPrettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public String getQuotaUser() {
            return this.quotaUser;
        }

        public Builder setQuotaUser(String quotaUser) {
            this.quotaUser = quotaUser;
            return this;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public Builder setUserIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public GetSnapshotHttpRequest build() {
            String missing = "";
            if (this.snapshot == null) {
                missing = missing + " snapshot";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new GetSnapshotHttpRequest(this.access_token, this.callback, this.fields, this.key, this.prettyPrint, this.quotaUser, this.snapshot, this.userIp);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAccessToken(this.access_token);
            newBuilder.setCallback(this.callback);
            newBuilder.setFields(this.fields);
            newBuilder.setKey(this.key);
            newBuilder.setPrettyPrint(this.prettyPrint);
            newBuilder.setQuotaUser(this.quotaUser);
            newBuilder.setSnapshot(this.snapshot);
            newBuilder.setUserIp(this.userIp);
            return newBuilder;
        }
    }
}

