/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HostRule
implements ApiMessage {
    private final String description;
    private final List<String> hosts;
    private final String pathMatcher;
    private static final HostRule DEFAULT_INSTANCE = new HostRule();

    private HostRule() {
        this.description = null;
        this.hosts = null;
        this.pathMatcher = null;
    }

    private HostRule(String description, List<String> hosts, String pathMatcher) {
        this.description = description;
        this.hosts = hosts;
        this.pathMatcher = pathMatcher;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("description")) {
            return this.description;
        }
        if (fieldName.equals("hosts")) {
            return this.hosts;
        }
        if (fieldName.equals("pathMatcher")) {
            return this.pathMatcher;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getHostsList() {
        return this.hosts;
    }

    public String getPathMatcher() {
        return this.pathMatcher;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HostRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HostRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HostRule{description=" + this.description + ", hosts=" + this.hosts + ", pathMatcher=" + this.pathMatcher + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HostRule) {
            HostRule that = (HostRule)o;
            return Objects.equals(this.description, that.getDescription()) && Objects.equals(this.hosts, that.getHostsList()) && Objects.equals(this.pathMatcher, that.getPathMatcher());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.hosts, this.pathMatcher);
    }

    public static class Builder {
        private String description;
        private List<String> hosts;
        private String pathMatcher;

        Builder() {
        }

        public Builder mergeFrom(HostRule other) {
            if (other == HostRule.getDefaultInstance()) {
                return this;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getHostsList() != null) {
                this.hosts = other.hosts;
            }
            if (other.getPathMatcher() != null) {
                this.pathMatcher = other.pathMatcher;
            }
            return this;
        }

        Builder(HostRule source) {
            this.description = source.description;
            this.hosts = source.hosts;
            this.pathMatcher = source.pathMatcher;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public List<String> getHostsList() {
            return this.hosts;
        }

        public Builder addAllHosts(List<String> hosts) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>(hosts.size());
            }
            this.hosts.addAll(hosts);
            return this;
        }

        public Builder addHosts(String hosts) {
            this.hosts.add(hosts);
            return this;
        }

        public String getPathMatcher() {
            return this.pathMatcher;
        }

        public Builder setPathMatcher(String pathMatcher) {
            this.pathMatcher = pathMatcher;
            return this;
        }

        public HostRule build() {
            return new HostRule(this.description, this.hosts, this.pathMatcher);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDescription(this.description);
            newBuilder.addAllHosts(this.hosts);
            newBuilder.setPathMatcher(this.pathMatcher);
            return newBuilder;
        }
    }
}

