/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.Warning;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DisksScopedList
implements ApiMessage {
    private final List<Disk> disks;
    private final Warning warning;
    private static final DisksScopedList DEFAULT_INSTANCE = new DisksScopedList();

    private DisksScopedList() {
        this.disks = null;
        this.warning = null;
    }

    private DisksScopedList(List<Disk> disks, Warning warning) {
        this.disks = disks;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if (fieldName.equals("disks")) {
            return this.disks;
        }
        if (fieldName.equals("warning")) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<Disk> getDisksList() {
        return this.disks;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DisksScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DisksScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DisksScopedList{disks=" + this.disks + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisksScopedList) {
            DisksScopedList that = (DisksScopedList)o;
            return Objects.equals(this.disks, that.getDisksList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.disks, this.warning);
    }

    public static class Builder {
        private List<Disk> disks;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(DisksScopedList other) {
            if (other == DisksScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getDisksList() != null) {
                this.disks = other.disks;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(DisksScopedList source) {
            this.disks = source.disks;
            this.warning = source.warning;
        }

        public List<Disk> getDisksList() {
            return this.disks;
        }

        public Builder addAllDisks(List<Disk> disks) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(disks.size());
            }
            this.disks.addAll(disks);
            return this;
        }

        public Builder addDisks(Disk disks) {
            this.disks.add(disks);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public DisksScopedList build() {
            return new DisksScopedList(this.disks, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllDisks(this.disks);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

