/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.DeprecationStatus;
import com.google.cloud.compute.deprecated.DiskTypeId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DiskType
implements Serializable {
    static final Function<com.google.api.services.compute.model.DiskType, DiskType> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.DiskType, DiskType>(){

        public DiskType apply(com.google.api.services.compute.model.DiskType pb) {
            return DiskType.fromPb(pb);
        }
    };
    static final Function<DiskType, com.google.api.services.compute.model.DiskType> TO_PB_FUNCTION = new Function<DiskType, com.google.api.services.compute.model.DiskType>(){

        public com.google.api.services.compute.model.DiskType apply(DiskType diskType) {
            return diskType.toPb();
        }
    };
    private static final long serialVersionUID = -944042261695072026L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final String generatedId;
    private final DiskTypeId diskTypeId;
    private final Long creationTimestamp;
    private final String description;
    private final String validDiskSize;
    private final Long defaultDiskSizeGb;
    private final DeprecationStatus<DiskTypeId> deprecationStatus;

    private DiskType(Builder builder) {
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.diskTypeId = builder.diskTypeId;
        this.description = builder.description;
        this.validDiskSize = builder.validDiskSize;
        this.defaultDiskSizeGb = builder.defaultDiskSizeGb;
        this.deprecationStatus = builder.deprecationStatus;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public DiskTypeId getDiskTypeId() {
        return this.diskTypeId;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValidDiskSize() {
        return this.validDiskSize;
    }

    public Long getDefaultDiskSizeGb() {
        return this.defaultDiskSizeGb;
    }

    public DeprecationStatus<DiskTypeId> getDeprecationStatus() {
        return this.deprecationStatus;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("description", (Object)this.description).add("validDiskSize", (Object)this.validDiskSize).add("defaultDiskSizeGb", (Object)this.defaultDiskSizeGb).add("deprecationStatus", this.deprecationStatus).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.diskTypeId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(DiskType.class) && Objects.equals(this.toPb(), ((DiskType)obj).toPb());
    }

    com.google.api.services.compute.model.DiskType toPb() {
        com.google.api.services.compute.model.DiskType diskTypePb = new com.google.api.services.compute.model.DiskType();
        if (this.generatedId != null) {
            diskTypePb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            diskTypePb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        diskTypePb.setDescription(this.description);
        diskTypePb.setValidDiskSize(this.validDiskSize);
        diskTypePb.setSelfLink(this.diskTypeId.getSelfLink());
        diskTypePb.setDefaultDiskSizeGb(this.defaultDiskSizeGb);
        diskTypePb.setZone(this.diskTypeId.getZoneId().getSelfLink());
        if (this.deprecationStatus != null) {
            diskTypePb.setDeprecated(this.deprecationStatus.toPb());
        }
        return diskTypePb;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static DiskType fromPb(com.google.api.services.compute.model.DiskType diskTypePb) {
        Builder builder = DiskType.newBuilder();
        if (diskTypePb.getId() != null) {
            builder.setGeneratedId(diskTypePb.getId().toString());
        }
        if (diskTypePb.getCreationTimestamp() != null) {
            builder.setCreationTimestamp(TIMESTAMP_FORMATTER.parseMillis(diskTypePb.getCreationTimestamp()));
        }
        builder.setDiskTypeId(DiskTypeId.fromUrl(diskTypePb.getSelfLink()));
        builder.setDescription(diskTypePb.getDescription());
        builder.setValidDiskSize(diskTypePb.getValidDiskSize());
        builder.setDefaultDiskSizeGb(diskTypePb.getDefaultDiskSizeGb());
        if (diskTypePb.getDeprecated() != null) {
            builder.setDeprecationStatus(DeprecationStatus.fromPb(diskTypePb.getDeprecated(), DiskTypeId.FROM_URL_FUNCTION));
        }
        return builder.build();
    }

    static final class Builder {
        private String generatedId;
        private DiskTypeId diskTypeId;
        private Long creationTimestamp;
        private String description;
        private String validDiskSize;
        private Long defaultDiskSizeGb;
        private DeprecationStatus<DiskTypeId> deprecationStatus;

        private Builder() {
        }

        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        Builder setDiskTypeId(DiskTypeId diskTypeId) {
            this.diskTypeId = diskTypeId;
            return this;
        }

        Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        Builder setValidDiskSize(String validDiskSize) {
            this.validDiskSize = validDiskSize;
            return this;
        }

        Builder setDefaultDiskSizeGb(Long defaultDiskSizeGb) {
            this.defaultDiskSizeGb = defaultDiskSizeGb;
            return this;
        }

        Builder setDeprecationStatus(DeprecationStatus<DiskTypeId> deprecationStatus) {
            this.deprecationStatus = deprecationStatus;
            return this;
        }

        DiskType build() {
            return new DiskType(this);
        }
    }
}

