/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class OperationId
extends ResourceId {
    private static final long serialVersionUID = -5502909279744388604L;
    private final String operation;

    OperationId(String project, String operation) {
        super(project);
        this.operation = (String)Preconditions.checkNotNull((Object)operation);
    }

    public abstract Type type();

    public String operation() {
        return this.operation;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("operation", (Object)this.operation);
    }

    @Override
    final int baseHashCode() {
        return Objects.hash(super.baseHashCode(), this.operation);
    }

    @Override
    final boolean baseEquals(ResourceId resourceId) {
        return resourceId instanceof OperationId && super.baseEquals(resourceId) && Objects.equals(this.operation, ((OperationId)resourceId).operation);
    }

    @Override
    abstract OperationId setProjectId(String var1);

    static enum Type {
        GLOBAL,
        REGION,
        ZONE;

    }
}

