/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.RegionId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegionAddressId
extends AddressId {
    private static final String REGEX = ".*?projects/([^/]+)/regions/([^/]+)/addresses/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/regions/([^/]+)/addresses/([^/]+)");
    private static final long serialVersionUID = 8170980880371085238L;
    private final String region;

    private RegionAddressId(String project, String region, String address) {
        super(project, address);
        this.region = (String)Preconditions.checkNotNull((Object)region);
    }

    @Override
    public AddressId.Type getType() {
        return AddressId.Type.REGION;
    }

    public String getRegion() {
        return this.region;
    }

    public RegionId getRegionId() {
        return RegionId.of(this.getProject(), this.region);
    }

    @Override
    public String getSelfLink() {
        String string = String.valueOf(String.valueOf(super.getSelfLink()));
        String string2 = String.valueOf(String.valueOf(this.region));
        String string3 = String.valueOf(String.valueOf(this.getAddress()));
        return new StringBuilder(20 + string.length() + string2.length() + string3.length()).append(string).append("/regions/").append(string2).append("/addresses/").append(string3).toString();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("region", (Object)this.region);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.region);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegionAddressId)) {
            return false;
        }
        RegionAddressId other = (RegionAddressId)obj;
        return this.baseEquals(other) && Objects.equals(this.region, other.region);
    }

    @Override
    RegionAddressId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return RegionAddressId.of(projectId, this.region, this.getAddress());
    }

    public static RegionAddressId of(RegionId regionId, String address) {
        return new RegionAddressId(regionId.getProject(), regionId.getRegion(), address);
    }

    public static RegionAddressId of(String region, String address) {
        return new RegionAddressId(null, region, address);
    }

    public static RegionAddressId of(String project, String region, String address) {
        return new RegionAddressId(project, region, address);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static RegionAddressId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(url).concat(" is not a valid region address URL"));
        }
        return RegionAddressId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

