/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.ZoneId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MachineTypeId
extends ResourceId {
    static final Function<String, MachineTypeId> FROM_URL_FUNCTION = new Function<String, MachineTypeId>(){

        public MachineTypeId apply(String pb) {
            return MachineTypeId.fromUrl(pb);
        }
    };
    static final Function<MachineTypeId, String> TO_URL_FUNCTION = new Function<MachineTypeId, String>(){

        public String apply(MachineTypeId machineTypeId) {
            return machineTypeId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/zones/([^/]+)/machineTypes/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/zones/([^/]+)/machineTypes/([^/]+)");
    private static final long serialVersionUID = -5819598544478859608L;
    private final String zone;
    private final String type;

    private MachineTypeId(String project, String zone, String type) {
        super(project);
        this.zone = (String)Preconditions.checkNotNull((Object)zone);
        this.type = (String)Preconditions.checkNotNull((Object)type);
    }

    public String getType() {
        return this.type;
    }

    public String getZone() {
        return this.zone;
    }

    public ZoneId getZoneId() {
        return ZoneId.of(this.getProject(), this.zone);
    }

    @Override
    public String getSelfLink() {
        String string = String.valueOf(String.valueOf(super.getSelfLink()));
        String string2 = String.valueOf(String.valueOf(this.zone));
        String string3 = String.valueOf(String.valueOf(this.type));
        return new StringBuilder(21 + string.length() + string2.length() + string3.length()).append(string).append("/zones/").append(string2).append("/machineTypes/").append(string3).toString();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("zone", (Object)this.zone).add("type", (Object)this.type);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.zone, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MachineTypeId)) {
            return false;
        }
        MachineTypeId other = (MachineTypeId)obj;
        return this.baseEquals(other) && Objects.equals(this.zone, other.zone) && Objects.equals(this.type, other.type);
    }

    @Override
    MachineTypeId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return MachineTypeId.of(projectId, this.zone, this.type);
    }

    public static MachineTypeId of(String zone, String type) {
        return new MachineTypeId(null, zone, type);
    }

    public static MachineTypeId of(String project, String zone, String type) {
        return new MachineTypeId(project, zone, type);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static MachineTypeId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(url).concat(" is not a valid machine type URL"));
        }
        return MachineTypeId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

