/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.HttpTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeFactory;
import com.google.cloud.compute.ComputeImpl;
import com.google.cloud.compute.spi.ComputeRpcFactory;
import com.google.cloud.compute.spi.v1.ComputeRpc;
import com.google.cloud.compute.spi.v1.HttpComputeRpc;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class ComputeOptions
extends ServiceOptions<Compute, ComputeOptions> {
    private static final String API_SHORT_NAME = "Compute";
    private static final String COMPUTE_SCOPE = "https://www.googleapis.com/auth/compute";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/compute");
    private static final long serialVersionUID = 6983703596543425691L;

    private ComputeOptions(Builder builder) {
        super(ComputeFactory.class, ComputeRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new ComputeDefaults());
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected ComputeRpc getComputeRpcV1() {
        return (ComputeRpc)this.getRpc();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComputeOptions)) {
            return false;
        }
        ComputeOptions other = (ComputeOptions)((Object)obj);
        return this.baseEquals(other);
    }

    public static ComputeOptions getDefaultInstance() {
        return ComputeOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class ComputeDefaults
    implements ServiceDefaults<Compute, ComputeOptions> {
        private ComputeDefaults() {
        }

        public ComputeFactory getDefaultServiceFactory() {
            return DefaultComputeFactory.INSTANCE;
        }

        public ComputeRpcFactory getDefaultRpcFactory() {
            return DefaultComputeRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return ComputeOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Compute, ComputeOptions, Builder> {
        private Builder() {
        }

        private Builder(ComputeOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Compute.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public ComputeOptions build() {
            return new ComputeOptions(this);
        }
    }

    public static class DefaultComputeRpcFactory
    implements ComputeRpcFactory {
        private static final ComputeRpcFactory INSTANCE = new DefaultComputeRpcFactory();

        public ServiceRpc create(ComputeOptions options) {
            return new HttpComputeRpc(options);
        }
    }

    public static class DefaultComputeFactory
    implements ComputeFactory {
        private static final ComputeFactory INSTANCE = new DefaultComputeFactory();

        public Compute create(ComputeOptions options) {
            return new ComputeImpl(options);
        }
    }
}

