/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class DiskMoveRequest
implements ApiMessage {
    private final String destinationZone;
    private final String targetDisk;
    private static final DiskMoveRequest DEFAULT_INSTANCE = new DiskMoveRequest();

    private DiskMoveRequest() {
        this.destinationZone = null;
        this.targetDisk = null;
    }

    private DiskMoveRequest(String destinationZone, String targetDisk) {
        this.destinationZone = destinationZone;
        this.targetDisk = targetDisk;
    }

    public Object getFieldValue(String fieldName) {
        if ("destinationZone".equals(fieldName)) {
            return this.destinationZone;
        }
        if ("targetDisk".equals(fieldName)) {
            return this.targetDisk;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getDestinationZone() {
        return this.destinationZone;
    }

    public String getTargetDisk() {
        return this.targetDisk;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DiskMoveRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static DiskMoveRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "DiskMoveRequest{destinationZone=" + this.destinationZone + ", targetDisk=" + this.targetDisk + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DiskMoveRequest) {
            DiskMoveRequest that = (DiskMoveRequest)o;
            return Objects.equals(this.destinationZone, that.getDestinationZone()) && Objects.equals(this.targetDisk, that.getTargetDisk());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.destinationZone, this.targetDisk);
    }

    public static class Builder {
        private String destinationZone;
        private String targetDisk;

        Builder() {
        }

        public Builder mergeFrom(DiskMoveRequest other) {
            if (other == DiskMoveRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getDestinationZone() != null) {
                this.destinationZone = other.destinationZone;
            }
            if (other.getTargetDisk() != null) {
                this.targetDisk = other.targetDisk;
            }
            return this;
        }

        Builder(DiskMoveRequest source) {
            this.destinationZone = source.destinationZone;
            this.targetDisk = source.targetDisk;
        }

        public String getDestinationZone() {
            return this.destinationZone;
        }

        public Builder setDestinationZone(String destinationZone) {
            this.destinationZone = destinationZone;
            return this;
        }

        public String getTargetDisk() {
            return this.targetDisk;
        }

        public Builder setTargetDisk(String targetDisk) {
            this.targetDisk = targetDisk;
            return this;
        }

        public DiskMoveRequest build() {
            return new DiskMoveRequest(this.destinationZone, this.targetDisk);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setDestinationZone(this.destinationZone);
            newBuilder.setTargetDisk(this.targetDisk);
            return newBuilder;
        }
    }
}

