/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Duration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class OutlierDetection
implements ApiMessage {
    private final Duration baseEjectionTime;
    private final Integer consecutiveErrors;
    private final Integer consecutiveGatewayFailure;
    private final Integer enforcingConsecutiveErrors;
    private final Integer enforcingConsecutiveGatewayFailure;
    private final Integer enforcingSuccessRate;
    private final Duration interval;
    private final Integer maxEjectionPercent;
    private final Integer successRateMinimumHosts;
    private final Integer successRateRequestVolume;
    private final Integer successRateStdevFactor;
    private static final OutlierDetection DEFAULT_INSTANCE = new OutlierDetection();

    private OutlierDetection() {
        this.baseEjectionTime = null;
        this.consecutiveErrors = null;
        this.consecutiveGatewayFailure = null;
        this.enforcingConsecutiveErrors = null;
        this.enforcingConsecutiveGatewayFailure = null;
        this.enforcingSuccessRate = null;
        this.interval = null;
        this.maxEjectionPercent = null;
        this.successRateMinimumHosts = null;
        this.successRateRequestVolume = null;
        this.successRateStdevFactor = null;
    }

    private OutlierDetection(Duration baseEjectionTime, Integer consecutiveErrors, Integer consecutiveGatewayFailure, Integer enforcingConsecutiveErrors, Integer enforcingConsecutiveGatewayFailure, Integer enforcingSuccessRate, Duration interval, Integer maxEjectionPercent, Integer successRateMinimumHosts, Integer successRateRequestVolume, Integer successRateStdevFactor) {
        this.baseEjectionTime = baseEjectionTime;
        this.consecutiveErrors = consecutiveErrors;
        this.consecutiveGatewayFailure = consecutiveGatewayFailure;
        this.enforcingConsecutiveErrors = enforcingConsecutiveErrors;
        this.enforcingConsecutiveGatewayFailure = enforcingConsecutiveGatewayFailure;
        this.enforcingSuccessRate = enforcingSuccessRate;
        this.interval = interval;
        this.maxEjectionPercent = maxEjectionPercent;
        this.successRateMinimumHosts = successRateMinimumHosts;
        this.successRateRequestVolume = successRateRequestVolume;
        this.successRateStdevFactor = successRateStdevFactor;
    }

    public Object getFieldValue(String fieldName) {
        if ("baseEjectionTime".equals(fieldName)) {
            return this.baseEjectionTime;
        }
        if ("consecutiveErrors".equals(fieldName)) {
            return this.consecutiveErrors;
        }
        if ("consecutiveGatewayFailure".equals(fieldName)) {
            return this.consecutiveGatewayFailure;
        }
        if ("enforcingConsecutiveErrors".equals(fieldName)) {
            return this.enforcingConsecutiveErrors;
        }
        if ("enforcingConsecutiveGatewayFailure".equals(fieldName)) {
            return this.enforcingConsecutiveGatewayFailure;
        }
        if ("enforcingSuccessRate".equals(fieldName)) {
            return this.enforcingSuccessRate;
        }
        if ("interval".equals(fieldName)) {
            return this.interval;
        }
        if ("maxEjectionPercent".equals(fieldName)) {
            return this.maxEjectionPercent;
        }
        if ("successRateMinimumHosts".equals(fieldName)) {
            return this.successRateMinimumHosts;
        }
        if ("successRateRequestVolume".equals(fieldName)) {
            return this.successRateRequestVolume;
        }
        if ("successRateStdevFactor".equals(fieldName)) {
            return this.successRateStdevFactor;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Duration getBaseEjectionTime() {
        return this.baseEjectionTime;
    }

    public Integer getConsecutiveErrors() {
        return this.consecutiveErrors;
    }

    public Integer getConsecutiveGatewayFailure() {
        return this.consecutiveGatewayFailure;
    }

    public Integer getEnforcingConsecutiveErrors() {
        return this.enforcingConsecutiveErrors;
    }

    public Integer getEnforcingConsecutiveGatewayFailure() {
        return this.enforcingConsecutiveGatewayFailure;
    }

    public Integer getEnforcingSuccessRate() {
        return this.enforcingSuccessRate;
    }

    public Duration getInterval() {
        return this.interval;
    }

    public Integer getMaxEjectionPercent() {
        return this.maxEjectionPercent;
    }

    public Integer getSuccessRateMinimumHosts() {
        return this.successRateMinimumHosts;
    }

    public Integer getSuccessRateRequestVolume() {
        return this.successRateRequestVolume;
    }

    public Integer getSuccessRateStdevFactor() {
        return this.successRateStdevFactor;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OutlierDetection prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static OutlierDetection getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "OutlierDetection{baseEjectionTime=" + this.baseEjectionTime + ", consecutiveErrors=" + this.consecutiveErrors + ", consecutiveGatewayFailure=" + this.consecutiveGatewayFailure + ", enforcingConsecutiveErrors=" + this.enforcingConsecutiveErrors + ", enforcingConsecutiveGatewayFailure=" + this.enforcingConsecutiveGatewayFailure + ", enforcingSuccessRate=" + this.enforcingSuccessRate + ", interval=" + this.interval + ", maxEjectionPercent=" + this.maxEjectionPercent + ", successRateMinimumHosts=" + this.successRateMinimumHosts + ", successRateRequestVolume=" + this.successRateRequestVolume + ", successRateStdevFactor=" + this.successRateStdevFactor + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OutlierDetection) {
            OutlierDetection that = (OutlierDetection)o;
            return Objects.equals(this.baseEjectionTime, that.getBaseEjectionTime()) && Objects.equals(this.consecutiveErrors, that.getConsecutiveErrors()) && Objects.equals(this.consecutiveGatewayFailure, that.getConsecutiveGatewayFailure()) && Objects.equals(this.enforcingConsecutiveErrors, that.getEnforcingConsecutiveErrors()) && Objects.equals(this.enforcingConsecutiveGatewayFailure, that.getEnforcingConsecutiveGatewayFailure()) && Objects.equals(this.enforcingSuccessRate, that.getEnforcingSuccessRate()) && Objects.equals(this.interval, that.getInterval()) && Objects.equals(this.maxEjectionPercent, that.getMaxEjectionPercent()) && Objects.equals(this.successRateMinimumHosts, that.getSuccessRateMinimumHosts()) && Objects.equals(this.successRateRequestVolume, that.getSuccessRateRequestVolume()) && Objects.equals(this.successRateStdevFactor, that.getSuccessRateStdevFactor());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.baseEjectionTime, this.consecutiveErrors, this.consecutiveGatewayFailure, this.enforcingConsecutiveErrors, this.enforcingConsecutiveGatewayFailure, this.enforcingSuccessRate, this.interval, this.maxEjectionPercent, this.successRateMinimumHosts, this.successRateRequestVolume, this.successRateStdevFactor);
    }

    public static class Builder {
        private Duration baseEjectionTime;
        private Integer consecutiveErrors;
        private Integer consecutiveGatewayFailure;
        private Integer enforcingConsecutiveErrors;
        private Integer enforcingConsecutiveGatewayFailure;
        private Integer enforcingSuccessRate;
        private Duration interval;
        private Integer maxEjectionPercent;
        private Integer successRateMinimumHosts;
        private Integer successRateRequestVolume;
        private Integer successRateStdevFactor;

        Builder() {
        }

        public Builder mergeFrom(OutlierDetection other) {
            if (other == OutlierDetection.getDefaultInstance()) {
                return this;
            }
            if (other.getBaseEjectionTime() != null) {
                this.baseEjectionTime = other.baseEjectionTime;
            }
            if (other.getConsecutiveErrors() != null) {
                this.consecutiveErrors = other.consecutiveErrors;
            }
            if (other.getConsecutiveGatewayFailure() != null) {
                this.consecutiveGatewayFailure = other.consecutiveGatewayFailure;
            }
            if (other.getEnforcingConsecutiveErrors() != null) {
                this.enforcingConsecutiveErrors = other.enforcingConsecutiveErrors;
            }
            if (other.getEnforcingConsecutiveGatewayFailure() != null) {
                this.enforcingConsecutiveGatewayFailure = other.enforcingConsecutiveGatewayFailure;
            }
            if (other.getEnforcingSuccessRate() != null) {
                this.enforcingSuccessRate = other.enforcingSuccessRate;
            }
            if (other.getInterval() != null) {
                this.interval = other.interval;
            }
            if (other.getMaxEjectionPercent() != null) {
                this.maxEjectionPercent = other.maxEjectionPercent;
            }
            if (other.getSuccessRateMinimumHosts() != null) {
                this.successRateMinimumHosts = other.successRateMinimumHosts;
            }
            if (other.getSuccessRateRequestVolume() != null) {
                this.successRateRequestVolume = other.successRateRequestVolume;
            }
            if (other.getSuccessRateStdevFactor() != null) {
                this.successRateStdevFactor = other.successRateStdevFactor;
            }
            return this;
        }

        Builder(OutlierDetection source) {
            this.baseEjectionTime = source.baseEjectionTime;
            this.consecutiveErrors = source.consecutiveErrors;
            this.consecutiveGatewayFailure = source.consecutiveGatewayFailure;
            this.enforcingConsecutiveErrors = source.enforcingConsecutiveErrors;
            this.enforcingConsecutiveGatewayFailure = source.enforcingConsecutiveGatewayFailure;
            this.enforcingSuccessRate = source.enforcingSuccessRate;
            this.interval = source.interval;
            this.maxEjectionPercent = source.maxEjectionPercent;
            this.successRateMinimumHosts = source.successRateMinimumHosts;
            this.successRateRequestVolume = source.successRateRequestVolume;
            this.successRateStdevFactor = source.successRateStdevFactor;
        }

        public Duration getBaseEjectionTime() {
            return this.baseEjectionTime;
        }

        public Builder setBaseEjectionTime(Duration baseEjectionTime) {
            this.baseEjectionTime = baseEjectionTime;
            return this;
        }

        public Integer getConsecutiveErrors() {
            return this.consecutiveErrors;
        }

        public Builder setConsecutiveErrors(Integer consecutiveErrors) {
            this.consecutiveErrors = consecutiveErrors;
            return this;
        }

        public Integer getConsecutiveGatewayFailure() {
            return this.consecutiveGatewayFailure;
        }

        public Builder setConsecutiveGatewayFailure(Integer consecutiveGatewayFailure) {
            this.consecutiveGatewayFailure = consecutiveGatewayFailure;
            return this;
        }

        public Integer getEnforcingConsecutiveErrors() {
            return this.enforcingConsecutiveErrors;
        }

        public Builder setEnforcingConsecutiveErrors(Integer enforcingConsecutiveErrors) {
            this.enforcingConsecutiveErrors = enforcingConsecutiveErrors;
            return this;
        }

        public Integer getEnforcingConsecutiveGatewayFailure() {
            return this.enforcingConsecutiveGatewayFailure;
        }

        public Builder setEnforcingConsecutiveGatewayFailure(Integer enforcingConsecutiveGatewayFailure) {
            this.enforcingConsecutiveGatewayFailure = enforcingConsecutiveGatewayFailure;
            return this;
        }

        public Integer getEnforcingSuccessRate() {
            return this.enforcingSuccessRate;
        }

        public Builder setEnforcingSuccessRate(Integer enforcingSuccessRate) {
            this.enforcingSuccessRate = enforcingSuccessRate;
            return this;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public Builder setInterval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public Integer getMaxEjectionPercent() {
            return this.maxEjectionPercent;
        }

        public Builder setMaxEjectionPercent(Integer maxEjectionPercent) {
            this.maxEjectionPercent = maxEjectionPercent;
            return this;
        }

        public Integer getSuccessRateMinimumHosts() {
            return this.successRateMinimumHosts;
        }

        public Builder setSuccessRateMinimumHosts(Integer successRateMinimumHosts) {
            this.successRateMinimumHosts = successRateMinimumHosts;
            return this;
        }

        public Integer getSuccessRateRequestVolume() {
            return this.successRateRequestVolume;
        }

        public Builder setSuccessRateRequestVolume(Integer successRateRequestVolume) {
            this.successRateRequestVolume = successRateRequestVolume;
            return this;
        }

        public Integer getSuccessRateStdevFactor() {
            return this.successRateStdevFactor;
        }

        public Builder setSuccessRateStdevFactor(Integer successRateStdevFactor) {
            this.successRateStdevFactor = successRateStdevFactor;
            return this;
        }

        public OutlierDetection build() {
            return new OutlierDetection(this.baseEjectionTime, this.consecutiveErrors, this.consecutiveGatewayFailure, this.enforcingConsecutiveErrors, this.enforcingConsecutiveGatewayFailure, this.enforcingSuccessRate, this.interval, this.maxEjectionPercent, this.successRateMinimumHosts, this.successRateRequestVolume, this.successRateStdevFactor);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setBaseEjectionTime(this.baseEjectionTime);
            newBuilder.setConsecutiveErrors(this.consecutiveErrors);
            newBuilder.setConsecutiveGatewayFailure(this.consecutiveGatewayFailure);
            newBuilder.setEnforcingConsecutiveErrors(this.enforcingConsecutiveErrors);
            newBuilder.setEnforcingConsecutiveGatewayFailure(this.enforcingConsecutiveGatewayFailure);
            newBuilder.setEnforcingSuccessRate(this.enforcingSuccessRate);
            newBuilder.setInterval(this.interval);
            newBuilder.setMaxEjectionPercent(this.maxEjectionPercent);
            newBuilder.setSuccessRateMinimumHosts(this.successRateMinimumHosts);
            newBuilder.setSuccessRateRequestVolume(this.successRateRequestVolume);
            newBuilder.setSuccessRateStdevFactor(this.successRateStdevFactor);
            return newBuilder;
        }
    }
}

