/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionNotificationEndpointHttpRequest;
import com.google.cloud.compute.v1.GetRegionNotificationEndpointHttpRequest;
import com.google.cloud.compute.v1.InsertRegionNotificationEndpointHttpRequest;
import com.google.cloud.compute.v1.ListRegionNotificationEndpointsHttpRequest;
import com.google.cloud.compute.v1.NotificationEndpoint;
import com.google.cloud.compute.v1.NotificationEndpointList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionNotificationEndpointClient;
import com.google.cloud.compute.v1.stub.HttpJsonRegionNotificationEndpointStub;
import com.google.cloud.compute.v1.stub.RegionNotificationEndpointStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionNotificationEndpointStubSettings
extends StubSettings<RegionNotificationEndpointStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionNotificationEndpointHttpRequest, Operation> deleteRegionNotificationEndpointSettings;
    private final UnaryCallSettings<GetRegionNotificationEndpointHttpRequest, NotificationEndpoint> getRegionNotificationEndpointSettings;
    private final UnaryCallSettings<InsertRegionNotificationEndpointHttpRequest, Operation> insertRegionNotificationEndpointSettings;
    private final PagedCallSettings<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse> listRegionNotificationEndpointsSettings;
    private static final PagedListDescriptor<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint> LIST_REGION_NOTIFICATION_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionNotificationEndpointsHttpRequest injectToken(ListRegionNotificationEndpointsHttpRequest payload, String token) {
            return ListRegionNotificationEndpointsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionNotificationEndpointsHttpRequest injectPageSize(ListRegionNotificationEndpointsHttpRequest payload, int pageSize) {
            return ListRegionNotificationEndpointsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionNotificationEndpointsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NotificationEndpointList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NotificationEndpoint> extractResources(NotificationEndpointList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse> LIST_REGION_NOTIFICATION_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse>(){

        public ApiFuture<RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList> callable, ListRegionNotificationEndpointsHttpRequest request, ApiCallContext context, ApiFuture<NotificationEndpointList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_NOTIFICATION_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse.createAsync((PageContext<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, NotificationEndpoint>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionNotificationEndpointHttpRequest, Operation> deleteRegionNotificationEndpointSettings() {
        return this.deleteRegionNotificationEndpointSettings;
    }

    public UnaryCallSettings<GetRegionNotificationEndpointHttpRequest, NotificationEndpoint> getRegionNotificationEndpointSettings() {
        return this.getRegionNotificationEndpointSettings;
    }

    public UnaryCallSettings<InsertRegionNotificationEndpointHttpRequest, Operation> insertRegionNotificationEndpointSettings() {
        return this.insertRegionNotificationEndpointSettings;
    }

    public PagedCallSettings<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse> listRegionNotificationEndpointsSettings() {
        return this.listRegionNotificationEndpointsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionNotificationEndpointStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionNotificationEndpointStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionNotificationEndpointStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionNotificationEndpointStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionNotificationEndpointStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionNotificationEndpointSettings = settingsBuilder.deleteRegionNotificationEndpointSettings().build();
        this.getRegionNotificationEndpointSettings = settingsBuilder.getRegionNotificationEndpointSettings().build();
        this.insertRegionNotificationEndpointSettings = settingsBuilder.insertRegionNotificationEndpointSettings().build();
        this.listRegionNotificationEndpointsSettings = settingsBuilder.listRegionNotificationEndpointsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionNotificationEndpointStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionNotificationEndpointHttpRequest, Operation> deleteRegionNotificationEndpointSettings;
        private final UnaryCallSettings.Builder<GetRegionNotificationEndpointHttpRequest, NotificationEndpoint> getRegionNotificationEndpointSettings;
        private final UnaryCallSettings.Builder<InsertRegionNotificationEndpointHttpRequest, Operation> insertRegionNotificationEndpointSettings;
        private final PagedCallSettings.Builder<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse> listRegionNotificationEndpointsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionNotificationEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionNotificationEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionNotificationEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionNotificationEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_NOTIFICATION_ENDPOINTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionNotificationEndpointSettings, this.getRegionNotificationEndpointSettings, this.insertRegionNotificationEndpointSettings, this.listRegionNotificationEndpointsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionNotificationEndpointStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionNotificationEndpointStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionNotificationEndpointStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionNotificationEndpointStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionNotificationEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionNotificationEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionNotificationEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionNotificationEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionNotificationEndpointStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionNotificationEndpointSettings = settings.deleteRegionNotificationEndpointSettings.toBuilder();
            this.getRegionNotificationEndpointSettings = settings.getRegionNotificationEndpointSettings.toBuilder();
            this.insertRegionNotificationEndpointSettings = settings.insertRegionNotificationEndpointSettings.toBuilder();
            this.listRegionNotificationEndpointsSettings = settings.listRegionNotificationEndpointsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionNotificationEndpointSettings, this.getRegionNotificationEndpointSettings, this.insertRegionNotificationEndpointSettings, this.listRegionNotificationEndpointsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionNotificationEndpointHttpRequest, Operation> deleteRegionNotificationEndpointSettings() {
            return this.deleteRegionNotificationEndpointSettings;
        }

        public UnaryCallSettings.Builder<GetRegionNotificationEndpointHttpRequest, NotificationEndpoint> getRegionNotificationEndpointSettings() {
            return this.getRegionNotificationEndpointSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionNotificationEndpointHttpRequest, Operation> insertRegionNotificationEndpointSettings() {
            return this.insertRegionNotificationEndpointSettings;
        }

        public PagedCallSettings.Builder<ListRegionNotificationEndpointsHttpRequest, NotificationEndpointList, RegionNotificationEndpointClient.ListRegionNotificationEndpointsPagedResponse> listRegionNotificationEndpointsSettings() {
            return this.listRegionNotificationEndpointsSettings;
        }

        public RegionNotificationEndpointStubSettings build() throws IOException {
            return new RegionNotificationEndpointStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

