/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.Warning;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SslCertificatesScopedList
implements ApiMessage {
    private final List<SslCertificate> sslCertificates;
    private final Warning warning;
    private static final SslCertificatesScopedList DEFAULT_INSTANCE = new SslCertificatesScopedList();

    private SslCertificatesScopedList() {
        this.sslCertificates = null;
        this.warning = null;
    }

    private SslCertificatesScopedList(List<SslCertificate> sslCertificates, Warning warning) {
        this.sslCertificates = sslCertificates;
        this.warning = warning;
    }

    public Object getFieldValue(String fieldName) {
        if ("sslCertificates".equals(fieldName)) {
            return this.sslCertificates;
        }
        if ("warning".equals(fieldName)) {
            return this.warning;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<SslCertificate> getSslCertificatesList() {
        return this.sslCertificates;
    }

    public Warning getWarning() {
        return this.warning;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SslCertificatesScopedList prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SslCertificatesScopedList getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SslCertificatesScopedList{sslCertificates=" + this.sslCertificates + ", warning=" + this.warning + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SslCertificatesScopedList) {
            SslCertificatesScopedList that = (SslCertificatesScopedList)o;
            return Objects.equals(this.sslCertificates, that.getSslCertificatesList()) && Objects.equals(this.warning, that.getWarning());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.sslCertificates, this.warning);
    }

    public static class Builder {
        private List<SslCertificate> sslCertificates;
        private Warning warning;

        Builder() {
        }

        public Builder mergeFrom(SslCertificatesScopedList other) {
            if (other == SslCertificatesScopedList.getDefaultInstance()) {
                return this;
            }
            if (other.getSslCertificatesList() != null) {
                this.sslCertificates = other.sslCertificates;
            }
            if (other.getWarning() != null) {
                this.warning = other.warning;
            }
            return this;
        }

        Builder(SslCertificatesScopedList source) {
            this.sslCertificates = source.sslCertificates;
            this.warning = source.warning;
        }

        public List<SslCertificate> getSslCertificatesList() {
            return this.sslCertificates;
        }

        public Builder addAllSslCertificates(List<SslCertificate> sslCertificates) {
            if (this.sslCertificates == null) {
                this.sslCertificates = new LinkedList<SslCertificate>();
            }
            this.sslCertificates.addAll(sslCertificates);
            return this;
        }

        public Builder addSslCertificates(SslCertificate sslCertificates) {
            if (this.sslCertificates == null) {
                this.sslCertificates = new LinkedList<SslCertificate>();
            }
            this.sslCertificates.add(sslCertificates);
            return this;
        }

        public Warning getWarning() {
            return this.warning;
        }

        public Builder setWarning(Warning warning) {
            this.warning = warning;
            return this;
        }

        public SslCertificatesScopedList build() {
            return new SslCertificatesScopedList(this.sslCertificates, this.warning);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllSslCertificates(this.sslCertificates);
            newBuilder.setWarning(this.warning);
            return newBuilder;
        }
    }
}

