/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionNetworkEndpointGroupName
implements ResourceName {
    private final String networkEndpointGroup;
    private final String project;
    private final String region;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionNetworkEndpointGroupName(Builder builder) {
        this.networkEndpointGroup = (String)Preconditions.checkNotNull((Object)builder.getNetworkEndpointGroup());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
    }

    public static ProjectRegionNetworkEndpointGroupName of(String networkEndpointGroup, String project, String region) {
        return ProjectRegionNetworkEndpointGroupName.newBuilder().setNetworkEndpointGroup(networkEndpointGroup).setProject(project).setRegion(region).build();
    }

    public static String format(String networkEndpointGroup, String project, String region) {
        return ProjectRegionNetworkEndpointGroupName.of(networkEndpointGroup, project, region).toString();
    }

    public String getNetworkEndpointGroup() {
        return this.networkEndpointGroup;
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionNetworkEndpointGroupName projectRegionNetworkEndpointGroupName = this;
            synchronized (projectRegionNetworkEndpointGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"networkEndpointGroup", (Object)this.networkEndpointGroup);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionNetworkEndpointGroupName> newFactory() {
        return new ResourceNameFactory<ProjectRegionNetworkEndpointGroupName>(){

            public ProjectRegionNetworkEndpointGroupName parse(String formattedString) {
                return ProjectRegionNetworkEndpointGroupName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionNetworkEndpointGroupName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionNetworkEndpointGroupName.parse: formattedString not in valid format");
        return ProjectRegionNetworkEndpointGroupName.of((String)matchMap.get("networkEndpointGroup"), (String)matchMap.get("project"), (String)matchMap.get("region"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"networkEndpointGroup", this.networkEndpointGroup, "project", this.project, "region", this.region});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionNetworkEndpointGroupName) {
            ProjectRegionNetworkEndpointGroupName that = (ProjectRegionNetworkEndpointGroupName)o;
            return Objects.equals(this.networkEndpointGroup, that.getNetworkEndpointGroup()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.networkEndpointGroup, this.project, this.region);
    }

    public static class Builder {
        private String networkEndpointGroup;
        private String project;
        private String region;

        public String getNetworkEndpointGroup() {
            return this.networkEndpointGroup;
        }

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setNetworkEndpointGroup(String networkEndpointGroup) {
            this.networkEndpointGroup = networkEndpointGroup;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionNetworkEndpointGroupName projectRegionNetworkEndpointGroupName) {
            this.networkEndpointGroup = projectRegionNetworkEndpointGroupName.networkEndpointGroup;
            this.project = projectRegionNetworkEndpointGroupName.project;
            this.region = projectRegionNetworkEndpointGroupName.region;
        }

        public ProjectRegionNetworkEndpointGroupName build() {
            return new ProjectRegionNetworkEndpointGroupName(this);
        }
    }
}

